
import { Toaster } from "@/components/ui/toaster";
import { Toaster as Sonner } from "@/components/ui/sonner";
import { TooltipProvider } from "@/components/ui/tooltip";
import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
import { HashRouter, Routes, Route } from "react-router-dom";
import { HelmetProvider } from "react-helmet-async";
import { TemplateProvider } from "./wordpress/TemplateProvider";
import Index from "./pages/Index";
import About from "./pages/About";
import Resources from "./pages/Resources";
import Activites from "./pages/Activites";
import News from "./pages/News";
import Contact from "./pages/Contact";
import NotFound from "./pages/NotFound";
import AdminAccess from "./pages/AdminAccess";
import NewsDetail from "./pages/news/NewsDetail";

// À propos sous-pages
import Presentation from "./pages/about/Presentation";
import WorkPackages from "./pages/about/WorkPackages";
import Partners from "./pages/about/Partners";
import Chercheurs from "./pages/about/Chercheurs";

// Ressources sous-pages
import Deliverables from "./pages/resources/Deliverables";
import Publications from "./pages/resources/Publications";
import Videos from "./pages/resources/Videos";
import Presentations from "./pages/resources/Presentations";
import Data from "./pages/resources/Data";
import WordPressPageWrapper from "./components/wordpress/WordPressPageWrapper";

// Activites sous-pages
import DoctoralSchools from "./pages/activites/DoctoralSchools";
import Colloques from "./pages/activites/Colloques";
import Residences from "./pages/activites/Residences";
import LivingLabs from "./pages/activites/LivingLabs";
import ReseauxFormation from "./pages/activites/ReseauxFormation";
import Webinaires from "./pages/activites/Webinaires";

const queryClient = new QueryClient({
  defaultOptions: {
    queries: {
      refetchOnWindowFocus: false,
      staleTime: 5 * 60 * 1000,
    },
  },
});

const App = () => (
  <HelmetProvider>
    <QueryClientProvider client={queryClient}>
      <TooltipProvider>
        <Toaster />
        <Sonner />
        <HashRouter>
          <TemplateProvider>
            <Routes>
              <Route path="/" element={<Index />} />
              
              {/* À propos et ses sous-pages */}
              <Route path="/about" element={<About />} />
              <Route path="/about/presentation" element={<Presentation />} />
              <Route path="/about/work-packages" element={<WorkPackages />} />
              <Route path="/about/partners" element={<Partners />} />
              <Route path="/about/chercheurs" element={<Chercheurs />} />
              <Route path="/about/collaborators" element={<Chercheurs />} />
              
              {/* Routes individuelles pour chaque Work Package */}
              <Route path="/about/work-packages/:wpId" element={<WordPressPageWrapper />} />
              
              {/* Ressources et ses sous-pages */}
              <Route path="/resources" element={<Resources />} />
              <Route path="/resources/deliverables" element={<Deliverables />} />
              <Route path="/resources/publications" element={<Publications />} />
              <Route path="/resources/presentations" element={<Presentations />} />
              <Route path="/resources/data" element={<Data />} />
              <Route path="/resources/videos" element={<Videos />} />
              
              {/* Activites et ses sous-pages */}
              <Route path="/activites" element={<Activites />} />
              <Route path="/activites/doctoral-schools" element={<DoctoralSchools />} />
              <Route path="/activites/colloques" element={<Colloques />} />
              <Route path="/activites/residences" element={<Residences />} />
              <Route path="/activites/living-labs" element={<LivingLabs />} />
              <Route path="/activites/reseaux-formation" element={<ReseauxFormation />} />
              <Route path="/activites/webinaires" element={<Webinaires />} />
              
              {/* Actualités et événements */}
              <Route path="/news" element={<News />} />
              <Route path="/news/:slug" element={<NewsDetail />} />
              
              <Route path="/contact" element={<Contact />} />
              
              {/* Route générique pour les pages WordPress */}
              <Route path="/wordpress/:slug" element={<WordPressPageWrapper />} />
              
              {/* Page d'administration cachée */}
              <Route path="/admin-forestt-hub-access" element={<AdminAccess />} />
              
              {/* Route catch-all pour les pages non trouvées */}
              <Route path="*" element={<NotFound />} />
            </Routes>
          </TemplateProvider>
        </HashRouter>
      </TooltipProvider>
    </QueryClientProvider>
  </HelmetProvider>
);

export default App;
