
import { cn } from "@/lib/utils";

interface PartnerLogosProps {
  variant?: "default" | "footer" | "compact";
  className?: string;
}

const PartnerLogos = ({ variant = "default", className }: PartnerLogosProps) => {
  // Liste des partenaires par ordre alphabétique
  const partners = [
    { name: "AgroParisTech", logo: "/lovable-uploads/5f65ecfb-bffd-4574-a470-b6a35e13e681.png" },
    { name: "CIRAD", logo: "/lovable-uploads/51eb61a9-1c40-4e6f-b9a7-bd7b5ac797a8.png" },
    { name: "CNRS", logo: "/lovable-uploads/162dea14-be0d-480d-9fa7-bcf25437696f.png" },
    { name: "ECOFOR", logo: "/lovable-uploads/b022c4c0-5c09-47b8-aa17-061a272fa599.png" },
    { name: "EHESS", logo: "/lovable-uploads/9738fd93-61b3-41e7-aebb-9412028b989f.png" },
    { name: "ENSFEA", logo: "/lovable-uploads/c3c098c4-1632-40fd-b54a-3a792fa72b36.png" },
    { name: "Le Mans Université", logo: "/lovable-uploads/b188469f-2ab9-40dc-a7dd-9c92a6318f05.png" },
    { name: "INRAE", logo: "/lovable-uploads/fe646af5-39a4-49a4-b145-9bf577cf55d1.png" },
    { name: "ONF", logo: "/lovable-uploads/5e0c5302-a2c2-498e-b7d8-a4d3fd0beab2.png" },
    { name: "Université de Montpellier", logo: "/lovable-uploads/c8765bc5-2a53-4840-9b6d-ddfcf9cd8e16.png" },
    { name: "Université de Picardie Jules Verne", logo: "/lovable-uploads/55db35ad-724f-406d-b66c-750ee49843a5.png" },
    { name: "Université de Lorraine", logo: "/lovable-uploads/64454f46-282e-47b1-937a-49d06442a392.png" },
    { name: "Université Grenoble Alpes", logo: "/lovable-uploads/e4e2bb1d-648e-4f96-8878-7d41756c6f1c.png" },
    { name: "Université de Pau et des Pays de l'Adour", logo: "/lovable-uploads/e97f4c89-9839-4342-9b1d-b20de32135ad.png" },
    { name: "Université Toulouse 2 Jean Jaurès", logo: "/lovable-uploads/dfd8ffe9-59c6-402b-892d-a80165db9c48.png" }
  ];

  // Fonction pour déterminer les classes spécifiques à certains logos
  const getLogoSpecificClasses = (partnerName: string) => {
    switch(partnerName) {
      case "ENSFEA":
      case "INRAE":
        // Réduire la taille des logos trop grands
        return "scale-90";
      case "Université Toulouse 2 Jean Jaurès":
        // Agrandir le logo trop petit
        return "scale-125";
      default:
        return "";
    }
  };

  return (
    <div className={cn(
      "flex flex-wrap items-center justify-center gap-8", 
      variant === "footer" && "gap-6",
      variant === "compact" && "gap-4",
      className
    )}>
      {partners.map((partner) => (
        <div key={partner.name} className={cn(
          "relative", 
          variant === "default" ? "h-16 w-auto" : 
          variant === "footer" ? "h-14 w-auto" : 
          "h-10 w-auto"
        )}>
          <img 
            src={partner.logo} 
            alt={`Logo ${partner.name}`} 
            className={cn(
              "h-full w-auto object-contain",
              getLogoSpecificClasses(partner.name)
            )}
          />
        </div>
      ))}
    </div>
  );
};

export default PartnerLogos;
