
import { Mail, Phone, MapPin } from "lucide-react";

const ContactInfo = () => {
  return (
    <div className="lg:col-span-1 space-y-6">
      <div className="bg-white border border-gray-200 rounded-xl shadow-sm animate-slide-up">
        <h3 className="text-xl font-semibold mb-3 p-6 pb-0">Coordonnées du GIP ECOFOR</h3>
        
        <div className="space-y-4 px-6 pb-6">
          <div className="flex items-start">
            <MapPin className="h-5 w-5 text-ecofor-dark-green mr-3 mt-1 flex-shrink-0" />
            <div>
              <p className="font-medium">Adresse</p>
              <address className="not-italic text-muted-foreground">
                42 rue Scheffer, 75116 Paris, France
              </address>
            </div>
          </div>

          <div className="flex items-start">
            <Mail className="h-5 w-5 text-ecofor-dark-green mr-3 mt-1 flex-shrink-0" />
            <div>
              <p className="font-medium">Email</p>
              <a 
                href="mailto:communication@gip-ecofor.fr" 
                className="text-muted-foreground hover:text-ecofor-dark-green transition-colors"
              >
                communication@gip-ecofor.fr
              </a>
            </div>
          </div>

          <div className="flex items-start">
            <Phone className="h-5 w-5 text-ecofor-dark-green mr-3 mt-1 flex-shrink-0" />
            <div>
              <p className="font-medium">Téléphone</p>
              <a 
                href="tel:+33153702170" 
                className="text-muted-foreground hover:text-ecofor-dark-green transition-colors"
              >
                +33 (0)1 53 70 21 70
              </a>
            </div>
          </div>
        </div>
      </div>

      <OfficeHours />
    </div>
  );
};

const OfficeHours = () => {
  return (
    <div className="bg-white border border-gray-200 rounded-xl shadow-sm animate-slide-up delay-100">
      <h3 className="text-xl font-semibold mb-2 p-6 pb-0">Horaires</h3>
      <div className="px-6 pb-6">
        <p className="text-muted-foreground mb-3">
          Notre équipe est disponible du lundi au vendredi.
        </p>
        <div className="space-y-2">
          <div className="flex justify-between">
            <span>Lundi - Vendredi</span>
            <span>9h00 - 17h00</span>
          </div>
          <div className="flex justify-between">
            <span>Samedi - Dimanche</span>
            <span>Fermé</span>
          </div>
        </div>
      </div>
    </div>
  );
};

export default ContactInfo;
