
import { ArrowRight } from "lucide-react";
import { Link } from "react-router-dom";

const Hero = () => {
  return (
    <section className="pt-28 pb-16 md:pt-32 md:pb-20 relative overflow-hidden">
      <div 
        className="absolute inset-0 z-0" 
        style={{
          backgroundImage: "url('/lovable-uploads/8b8e49d3-7ac6-4c41-810c-b064025df914.png')",
          backgroundSize: "cover",
          backgroundPosition: "center",
          opacity: 0.15
        }}
      ></div>
      
      <div className="container relative z-10">
        <div className="grid grid-cols-1 lg:grid-cols-12 gap-4 items-center">
          <div className="space-y-6 text-left lg:col-span-8">
            <div className="inline-block bg-forestt-primary/10 px-4 py-2 rounded-full text-forestt-primary font-medium text-sm">
              Projet-ciblé du PEPR FORESTT
            </div>
            
            <h1 className="text-5xl md:text-6xl lg:text-7xl font-extrabold tracking-tight text-forestt-primary animate-fade-in">
              <span className="block">FORESTT-HUB</span>
              <span className="text-3xl md:text-4xl text-forestt-secondary font-medium block mt-2">Forum d'intégration et de formation : Think-&-Do Tank</span>
            </h1>
            
            <div className="flex flex-col sm:flex-row gap-4 justify-start animate-slide-up delay-200">
              <Link
                to="/about"
                className="bg-forestt-primary text-white px-6 py-3 rounded-md font-medium hover:bg-forestt-primary/90 transition-colors inline-flex items-center justify-center"
              >
                Découvrir le projet-ciblé
                <ArrowRight className="ml-2 h-4 w-4" />
              </Link>
              
              <Link
                to="/resources"
                className="border border-forestt-primary text-forestt-primary px-6 py-3 rounded-md font-medium hover:bg-forestt-primary/10 transition-colors inline-flex items-center justify-center"
              >
                Accéder aux ressources
              </Link>
            </div>
          </div>
          
          <div className="lg:col-span-4 flex justify-center lg:justify-end">
            <div className="max-w-md relative animate-fade-in delay-300">
              <div className="relative w-full aspect-square overflow-hidden rounded-2xl shadow-xl">
                <img 
                  src="/lovable-uploads/5922e051-46bc-4fa6-86e8-b3cb84b770e1.png" 
                  alt="FORESTT-HUB" 
                  className="w-full h-full object-cover"
                />
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default Hero;
