
import { Link } from "react-router-dom";
import SectionHeading from "../common/SectionHeading";
import { Calendar, ArrowRight } from "lucide-react";
import Button from "../common/Button";

const LatestNews = () => {
  const news = [
    {
      id: 1,
      slug: "conference-internationale-forets-mediterraneennes",
      title: "Conférence internationale sur les forêts méditerranéennes",
      date: "15 Octobre 2023",
      description: "Une conférence réunissant experts et chercheurs pour discuter des défis spécifiques aux forêts méditerranéennes.",
      image: "https://images.unsplash.com/photo-1513836279014-a89f7a76ae86?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1288&q=80"
    },
    {
      id: 2,
      slug: "impact-changement-climatique-forets-mediterraneennes",
      title: "Publication de l'étude sur l'impact du changement climatique",
      date: "28 Septembre 2023",
      description: "Notre dernière étude révèle les impacts du changement climatique sur les écosystèmes forestiers européens.",
      image: "https://images.unsplash.com/photo-1502082553048-f009c37129b9?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1470&q=80"
    },
    {
      id: 3,
      slug: "atelier-doctoral-biodiversite-forestiere",
      title: "Atelier doctoral sur la biodiversité forestière",
      date: "10 Septembre 2023",
      description: "Un atelier destiné aux doctorants travaillant sur les questions de biodiversité dans les forêts tempérées.",
      image: "https://images.unsplash.com/photo-1501854140801-50d01698950b?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1575&q=80"
    }
  ];

  return (
    <section className="py-16 md:py-24">
      <div className="container">
        <SectionHeading 
          title="Actualités et Événements" 
          subtitle="Restez informés des dernières nouvelles, publications et événements de notre projet"
        />

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          {news.map((item, index) => (
            <article 
              key={item.id} 
              className="group flex flex-col h-full overflow-hidden rounded-xl border border-gray-200 bg-white shadow-sm transition-all hover:shadow-md animate-slide-up"
              style={{ animationDelay: `${index * 100 + 100}ms` }}
            >
              <div className="relative h-48 overflow-hidden">
                <div className="absolute inset-0 bg-gradient-to-t from-black/30 to-transparent z-10" />
                <img 
                  src={item.image} 
                  alt={item.title} 
                  className="h-full w-full object-cover transition-transform duration-500 group-hover:scale-105"
                />
              </div>
              <div className="flex flex-col flex-grow p-6">
                <div className="flex items-center mb-2 text-sm text-muted-foreground">
                  <Calendar className="mr-2 h-4 w-4 text-ecofor-turquoise" />
                  <time dateTime={item.date}>{item.date}</time>
                </div>
                <h3 className="text-xl font-semibold mb-2 text-foreground group-hover:text-ecofor-dark-green transition-colors">
                  {item.title}
                </h3>
                <p className="text-muted-foreground text-sm mt-2 mb-4 flex-grow">
                  {item.description}
                </p>
                <Link 
                  to={`/news/${item.slug}`} 
                  className="inline-flex items-center text-ecofor-dark-green font-medium transition-colors group-hover:text-ecofor-turquoise mt-auto"
                >
                  Lire la suite
                  <ArrowRight className="ml-1 h-4 w-4 transition-transform group-hover:translate-x-1" />
                </Link>
              </div>
            </article>
          ))}
        </div>

        <div className="flex justify-center mt-10">
          <Link to="/news">
            <Button variant="outline" size="lg">
              Voir toutes les actualités
            </Button>
          </Link>
        </div>
      </div>
    </section>
  );
};

export default LatestNews;
