
import SectionHeading from "../common/SectionHeading";
import YouTubeEmbed from "../common/YouTubeEmbed";
import { Link } from "react-router-dom";
import { ExternalLink } from "lucide-react";

const VideoSection = () => {
  return (
    <section className="py-16 bg-gradient-to-b from-white to-forestt-primary/10">
      <div className="container">
        <SectionHeading
          title="Notre Projet-ciblé en Action"
          subtitle="Forum d'intégration et de formation : Think-&-Do Tank"
          centered={true}
        />
        
        <div className="mt-10 max-w-4xl mx-auto">
          <div className="relative rounded-xl overflow-hidden shadow-xl">
            <YouTubeEmbed 
              videoId="-ybgtSGPOLo" 
              title="Présentation du projet FORESTT-HUB"
            />
          </div>
          
          <div className="mt-8 text-center">
            <p className="text-muted-foreground italic">
              Cette vidéo présente les activités et la mission du projet-ciblé FORESTT-HUB sur les forêts et changements globaux.
            </p>
            
            <div className="mt-6 p-4 bg-forestt-primary/5 rounded-lg border border-forestt-primary/20">
              <p className="text-sm text-forestt-secondary">
                Notre projet-ciblé s'intègre dans le programme de recherche FORESTT consacré à la résilience des forêts françaises. 
                Pour plus d'informations sur le programme dans son ensemble, voir le {" "}
                <a 
                  href="https://www.pepr-forestt.org/" 
                  target="_blank" 
                  rel="noopener noreferrer"
                  className="text-forestt-primary hover:underline inline-flex items-center"
                >
                  site web dédié
                  <ExternalLink className="ml-1 h-3 w-3" />
                </a>
              </p>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
};

export default VideoSection;
