
import { Link, useLocation } from "react-router-dom";
import { cn } from "@/lib/utils";
import { NavigationMenu, NavigationMenuContent, NavigationMenuItem, NavigationMenuList, NavigationMenuTrigger } from "@/components/ui/navigation-menu";
import { navStructure } from "./navStructure";
import SearchButton from "@/components/search/SearchButton";
import { ChevronDown } from "lucide-react";
import { HoverCard, HoverCardContent, HoverCardTrigger } from "@/components/ui/hover-card";

const DesktopNavigation = () => {
  const location = useLocation();

  // Déterminer si un menu ou sous-menu est actif
  const isActive = (href: string, dropdownItems: Array<any> = []) => {
    if (location.pathname === href) return true;
    if (dropdownItems?.length) {
      for (const item of dropdownItems) {
        if (location.pathname === item.href) return true;
        if (item.subDropdownItems?.length) {
          for (const subItem of item.subDropdownItems) {
            if (location.pathname === subItem.href) return true;
          }
        }
      }
    }
    return false;
  };

  return (
    <div className="hidden md:flex items-center space-x-4">
      <NavigationMenu className="z-[101]">
        <NavigationMenuList>
          {navStructure.map(item => (
            <NavigationMenuItem key={item.name} className="relative">
              {item.hasDropdown ? (
                <>
                  <NavigationMenuTrigger 
                    className={cn(
                      "text-base font-medium transition-colors hover:text-forestt-primary", 
                      isActive(item.href, item.dropdownItems) ? "text-forestt-primary" : "text-foreground"
                    )}
                  >
                    <Link 
                      to={item.href} 
                      className="inline-flex items-center"
                      onClick={(e) => e.stopPropagation()}
                    >
                      {item.name}
                    </Link>
                  </NavigationMenuTrigger>
                  <NavigationMenuContent>
                    <ul className={cn(
                      "grid gap-3 p-4 bg-white shadow-lg rounded-md",
                      "min-w-[280px] w-auto"
                    )}>
                      {item.dropdownItems.map(subItem => (
                        <li key={subItem.name}>
                          {subItem.hasSubDropdown ? (
                            <div className="relative">
                              <HoverCard openDelay={100} closeDelay={200}>
                                <HoverCardTrigger asChild>
                                  <Link 
                                    to={subItem.href} 
                                    className={cn(
                                      "block select-none rounded-md p-3 leading-none no-underline outline-none transition-colors hover:bg-forestt-primary/10 hover:text-forestt-primary focus:bg-forestt-primary/10 focus:text-forestt-primary", 
                                      location.pathname === subItem.href ? "bg-forestt-primary/10 text-forestt-primary" : "text-foreground"
                                    )}
                                  >
                                    <div className="flex items-center justify-between">
                                      <span className="text-sm font-medium leading-none">{subItem.name}</span>
                                      <ChevronDown className="h-4 w-4 ml-2" />
                                    </div>
                                  </Link>
                                </HoverCardTrigger>
                                <HoverCardContent 
                                  side="right" 
                                  align="start" 
                                  className="w-auto p-2 bg-white rounded-md shadow-lg border border-forestt-primary/10 z-[103]"
                                  sideOffset={5}
                                >
                                  <div className="max-h-[300px] overflow-y-auto py-1">
                                    {subItem.subDropdownItems.map(subSubItem => (
                                      <Link 
                                        key={subSubItem.name}
                                        to={subSubItem.href} 
                                        className={cn(
                                          "block select-none rounded-md p-3 mb-1 leading-none no-underline outline-none transition-colors hover:bg-forestt-primary/10 hover:text-forestt-primary focus:bg-forestt-primary/10 focus:text-forestt-primary text-sm whitespace-nowrap", 
                                          location.pathname === subSubItem.href ? "bg-forestt-primary/10 text-forestt-primary" : "text-foreground"
                                        )}
                                      >
                                        {subSubItem.name}
                                      </Link>
                                    ))}
                                  </div>
                                </HoverCardContent>
                              </HoverCard>
                            </div>
                          ) : (
                            <Link 
                              to={subItem.href} 
                              className={cn(
                                "block select-none space-y-1 rounded-md p-3 leading-none no-underline outline-none transition-colors hover:bg-forestt-primary/10 hover:text-forestt-primary focus:bg-forestt-primary/10 focus:text-forestt-primary", 
                                location.pathname === subItem.href ? "bg-forestt-primary/10 text-forestt-primary" : "text-foreground"
                              )}
                            >
                              <div className="text-sm font-medium leading-none">{subItem.name}</div>
                            </Link>
                          )}
                        </li>
                      ))}
                    </ul>
                  </NavigationMenuContent>
                </>
              ) : (
                <Link 
                  to={item.href} 
                  className={cn(
                    "inline-flex h-10 w-max items-center justify-center rounded-md px-4 py-2 text-base font-medium transition-colors hover:text-forestt-primary focus:outline-none", 
                    location.pathname === item.href ? "text-forestt-primary" : "text-foreground"
                  )}
                >
                  {item.name}
                </Link>
              )}
            </NavigationMenuItem>
          ))}
        </NavigationMenuList>
      </NavigationMenu>
      <SearchButton />
    </div>
  );
};

export default DesktopNavigation;
