
import React from 'react';
import { FileText, Download } from "lucide-react";

interface Deliverable {
  id: string | number;
  title: string;
  date: string;
  wp: string;
  description: string;
  downloadUrl?: string;  // Changé de fileUrl à downloadUrl
  authors?: string;
}

interface DeliverableCardProps {
  deliverable: Deliverable;
}

const DeliverableCard: React.FC<DeliverableCardProps> = ({ deliverable }) => {
  return (
    <div className="bg-white border border-gray-200 rounded-lg p-5 shadow-sm hover:shadow-md transition-shadow">
      <div className="flex flex-wrap gap-4 items-start">
        <div className="flex-shrink-0 bg-ecofor-light-blue p-3 rounded-md">
          <FileText size={24} className="text-ecofor-dark-green" />
        </div>
        <div className="flex-grow">
          <div className="flex flex-wrap justify-between items-start gap-2">
            <div>
              <h2 className="text-xl font-bold text-ecofor-dark-green">{deliverable.id}: {deliverable.title}</h2>
              <div className="flex flex-wrap gap-4 mt-1 mb-3">
                <span className="text-sm bg-ecofor-turquoise text-white px-2 py-1 rounded-full">{deliverable.wp}</span>
                <span className="text-sm text-gray-600">{deliverable.date}</span>
              </div>
            </div>
            {deliverable.downloadUrl && (
              <a 
                href={deliverable.downloadUrl} 
                className="inline-flex items-center bg-ecofor-dark-green hover:bg-ecofor-dark-green/90 text-white px-3 py-2 rounded-md transition-colors"
                download
              >
                <Download size={16} className="mr-2" />
                Télécharger
              </a>
            )}
          </div>
          <p>{deliverable.description}</p>
        </div>
      </div>
    </div>
  );
};

export default DeliverableCard;
