
import React from 'react';
import DeliverableCard from './DeliverableCard';
import { deliverables, Deliverable as DeliverableType } from '@/data/deliverables';

interface Deliverable {
  id: string | number;
  title: string;
  date: string;
  wp: string;
  description: string;
  downloadUrl?: string;
  authors?: string;
}

interface DeliverablesListProps {
  filter?: string;
}

const DeliverablesList: React.FC<DeliverablesListProps> = ({ filter = "all" }) => {
  // Filtrer les livrables en fonction du filtre WP
  const filteredDeliverables = filter === "all" 
    ? deliverables 
    : deliverables.filter(item => item.workPackage.toLowerCase() === filter.toLowerCase());

  return (
    <div className="space-y-6">
      {filteredDeliverables.length > 0 ? (
        filteredDeliverables.map((item) => (
          <DeliverableCard key={item.id} deliverable={{
            id: item.id,
            title: item.title,
            date: item.date,
            wp: item.workPackage,
            description: item.description,
            downloadUrl: item.fileUrl,
            authors: item.authors ? item.authors.join(", ") : ""
          }} />
        ))
      ) : (
        <p className="text-center py-8 text-gray-500">Aucun livrable disponible pour ce Work Package.</p>
      )}
    </div>
  );
};

export default DeliverablesList;
