
import React from 'react';
import { Presentation } from '@/data/presentations';
import { Card, CardContent } from "@/components/ui/card";
import { FileText, Calendar, User, ExternalLink } from "lucide-react";
import { Button } from "@/components/ui/button";

interface PresentationCardProps {
  presentation: Presentation;
}

const PresentationCard: React.FC<PresentationCardProps> = ({ presentation }) => {
  return (
    <Card className="bg-white hover:shadow-md transition-shadow">
      <CardContent className="p-6">
        <div className="flex flex-col md:flex-row gap-4">
          <div className="flex-shrink-0 bg-ecofor-light-blue/20 p-3 rounded-lg h-fit">
            <FileText className="h-6 w-6 text-ecofor-dark-green" />
          </div>
          <div className="flex-1">
            <h3 className="text-xl font-semibold mb-2 text-ecofor-dark-green">{presentation.title}</h3>
            
            <div className="mb-3 flex flex-wrap gap-3 text-sm text-gray-600">
              <div className="flex items-center">
                <Calendar className="h-4 w-4 mr-1 text-ecofor-turquoise" />
                {presentation.date}
              </div>
              <div className="flex items-center">
                <User className="h-4 w-4 mr-1 text-ecofor-turquoise" />
                {presentation.author}
              </div>
            </div>
            
            <p className="mb-4 text-gray-600">{presentation.description}</p>
            
            <div className="text-sm italic mb-4 text-gray-500">
              Présenté lors de : {presentation.event}
            </div>
            
            <Button 
              variant="outline" 
              className="border-ecofor-medium-blue text-ecofor-dark-green hover:bg-ecofor-light-blue/20"
              asChild
            >
              <a href={presentation.fileUrl} target="_blank" rel="noopener noreferrer">
                <ExternalLink className="h-4 w-4 mr-2" />
                Télécharger la présentation
              </a>
            </Button>
          </div>
        </div>
      </CardContent>
    </Card>
  );
};

export default PresentationCard;
