
import { useState } from "react";
import { Search } from "lucide-react";
import { Button } from "@/components/ui/button";
import SearchDialog from "./SearchDialog";

const SearchButton = () => {
  const [searchOpen, setSearchOpen] = useState(false);

  return (
    <>
      <Button
        variant="ghost"
        size="icon"
        className="text-foreground hover:bg-ecofor-light-blue hover:text-ecofor-dark-green"
        onClick={() => setSearchOpen(true)}
        aria-label="Recherche"
      >
        <Search className="h-5 w-5" />
      </Button>
      <SearchDialog open={searchOpen} onOpenChange={setSearchOpen} />
    </>
  );
};

export default SearchButton;
