
export interface ForestData {
  id: string;
  title: string;
  date: string;
  type: string;
  format: string;
  description: string;
  fileUrl: string;
  size: string;
  license: string;
}

export const forestDatasets: ForestData[] = [
  {
    id: "D1",
    title: "Inventaire national forestier 2023",
    date: "Décembre 2023",
    type: "Données d'inventaire",
    format: "CSV",
    description: "Données complètes de l'inventaire national forestier incluant structure des peuplements, composition spécifique et état sanitaire.",
    fileUrl: "/documents/data/inventaire_national_2023.zip",
    size: "1.2 Go",
    license: "CC BY-NC 4.0"
  },
  {
    id: "D2",
    title: "Séries climatiques des sites expérimentaux",
    date: "Octobre 2023",
    type: "Données climatiques",
    format: "NetCDF",
    description: "Données climatiques à haute résolution temporelle (horaire) des principaux sites expérimentaux du réseau FORESTT.",
    fileUrl: "/documents/data/climat_sites_exp.zip",
    size: "850 Mo",
    license: "CC BY 4.0"
  },
  {
    id: "D3",
    title: "Base de données phénologiques 2020-2023",
    date: "Août 2023",
    type: "Données phénologiques",
    format: "Excel",
    description: "Observations phénologiques de 25 espèces forestières sur 12 sites d'étude répartis sur le territoire français.",
    fileUrl: "/documents/data/phenologie_2020_2023.xlsx",
    size: "75 Mo",
    license: "CC BY-NC-SA 4.0"
  },
];
