
import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";
import { Link } from "react-router-dom";
import { Mic, Network, School, Users, VideoIcon, Webcam } from "lucide-react";

const Activites = () => {
  // Données des activités classées par ordre alphabétique
  const activites = [
    {
      title: "Colloques scientifiques",
      description: "Informations sur les colloques organisés dans le cadre du projet-ciblé FORESTT-HUB.",
      link: "/activites/colloques",
      icon: <Users className="w-10 h-10 text-forestt-primary mb-2" />
    },
    {
      title: "Écoles doctorales",
      description: "Ressources et formations pour les doctorants travaillant sur les thématiques forestières.",
      link: "/activites/doctoral-schools",
      icon: <School className="w-10 h-10 text-forestt-primary mb-2" />
    },
    {
      title: "Living Labs forestiers",
      description: "Espaces d'innovation ouverte ancrés dans les territoires forestiers.",
      link: "/activites/living-labs",
      icon: <Network className="w-10 h-10 text-forestt-primary mb-2" />
    },
    {
      title: "Réseaux de formation",
      description: "Formations et réseaux d'apprentissage dans le domaine forestier.",
      link: "/activites/reseaux-formation",
      icon: <Network className="w-10 h-10 text-forestt-primary mb-2" />
    },
    {
      title: "Résidences d'artistes",
      description: "Programme de résidences d'artistes pour sensibiliser aux enjeux forestiers.",
      link: "/activites/residences",
      icon: <Mic className="w-10 h-10 text-forestt-primary mb-2" />
    },
    {
      title: "Webinaires",
      description: "Séminaires en ligne sur les thématiques de recherche forestière.",
      link: "/activites/webinaires",
      icon: <Webcam className="w-10 h-10 text-forestt-primary mb-2" />
    }
  ];

  return (
    <PageLayout>
      <Helmet>
        <title>Activités - FORESTT-HUB | Forum d'intégration et de formation</title>
        <meta name="description" content="Découvrez les activités du projet-ciblé FORESTT-HUB : écoles doctorales, colloques scientifiques, résidences d'artistes, living labs et plus encore." />
      </Helmet>
      
      <section className="py-16">
        <div className="container">
          <h1 className="mb-8 text-center text-4xl font-bold md:text-5xl text-forestt-primary">
            Activités
          </h1>
          <p className="text-lg text-center mb-10 max-w-3xl mx-auto">
            Découvrez les différentes activités organisées dans le cadre du projet-ciblé FORESTT-HUB.
          </p>
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mt-12">
            {activites.map((activity) => (
              <div 
                key={activity.title} 
                className="bg-white border border-gray-200 rounded-lg p-6 shadow-sm hover:shadow-md transition-shadow flex flex-col items-center text-center"
              >
                {activity.icon}
                <h3 className="text-xl font-semibold mb-3 text-forestt-primary">{activity.title}</h3>
                <p className="mb-4">
                  {activity.description}
                </p>
                <Link to={activity.link} className="mt-auto text-forestt-primary hover:underline">
                  En savoir plus →
                </Link>
              </div>
            ))}
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default Activites;
