
import React from 'react';
import Navbar from "@/components/layout/Navbar";
import Footer from "@/components/layout/Footer";
import { Shield, Lock } from "lucide-react";
import { Button } from "@/components/ui/button";

const AdminAccess = () => {
  return (
    <div className="flex min-h-screen flex-col">
      <Navbar />
      <main className="flex-grow pt-24">
        <div className="container mx-auto px-4 py-12">
          <div className="max-w-3xl mx-auto bg-white rounded-lg shadow-md p-8 border border-ecofor-medium-blue">
            <div className="flex items-center justify-center mb-6">
              <Shield className="h-12 w-12 text-ecofor-dark-green mr-4" />
              <h1 className="text-3xl font-bold text-ecofor-dark-green">Zone d'Administration</h1>
            </div>
            
            <div className="mb-8 p-4 bg-ecofor-light-blue/20 rounded-md border border-ecofor-medium-blue">
              <div className="flex items-center mb-2">
                <Lock className="h-5 w-5 text-ecofor-dark-green mr-2" />
                <h2 className="text-xl font-semibold text-ecofor-dark-green">Accès sécurisé</h2>
              </div>
              <p className="mb-4 text-gray-700">
                Cette page est réservée aux administrateurs du site. Elle permet d'accéder
                au panneau d'administration de WordPress pour gérer le contenu du site.
              </p>
            </div>
            
            <div className="flex flex-col gap-4 items-center">
              <a 
                href="/wp-admin" 
                target="_blank" 
                rel="noopener noreferrer"
                className="w-full"
              >
                <Button className="w-full bg-ecofor-dark-green hover:bg-ecofor-dark-green/90 text-white py-3">
                  Accéder à l'Administration WordPress
                </Button>
              </a>
              
              <a 
                href="/" 
                className="text-ecofor-dark-green hover:underline mt-2"
              >
                Retourner à l'accueil
              </a>
            </div>
          </div>
        </div>
      </main>
      <Footer />
    </div>
  );
};

export default AdminAccess;
