
import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";

const Collaborators = () => {
  const collaborators = [
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur principal",
      organization: "Organisation 1",
      bio: "Courte biographie du collaborateur et son expertise dans le domaine.",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Coordinateur de projet",
      organization: "Organisation 2",
      bio: "Courte biographie du collaborateur et son expertise dans le domaine.",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Expert technique",
      organization: "Organisation 3",
      bio: "Courte biographie du collaborateur et son expertise dans le domaine.",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Analyste de données",
      organization: "Organisation 4",
      bio: "Courte biographie du collaborateur et son expertise dans le domaine.",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Chercheur associé",
      organization: "Organisation 5",
      bio: "Courte biographie du collaborateur et son expertise dans le domaine.",
      photo: "/placeholder.svg"
    },
    {
      name: "Dr. Nom Prénom",
      title: "Responsable communication",
      organization: "Organisation 6",
      bio: "Courte biographie du collaborateur et son expertise dans le domaine.",
      photo: "/placeholder.svg"
    },
  ];

  return (
    <PageLayout>
      <Helmet>
        <title>Chercheurs impliqués - FORESTT-HUB</title>
        <meta name="description" content="Découvrez les chercheurs impliqués dans le projet-ciblé FORESTT-HUB." />
      </Helmet>
      
      <section className="pt-32 pb-16">
        <div className="container">
          <h1 className="text-3xl font-bold mb-8 text-ecofor-dark-green">Chercheurs impliqués</h1>
          <p className="mb-8">
            Notre équipe de chercheurs combine expertise scientifique et technique pour atteindre les objectifs du projet.
          </p>

          <div className="grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
            {collaborators.map((person, index) => (
              <div key={index} className="bg-white border border-gray-200 rounded-lg shadow-sm overflow-hidden hover:shadow-md transition-shadow">
                <div className="aspect-square overflow-hidden bg-ecofor-light-blue/10">
                  <img 
                    src={person.photo} 
                    alt={person.name} 
                    className="w-full h-full object-cover"
                  />
                </div>
                <div className="p-4">
                  <h2 className="text-lg font-bold text-ecofor-dark-green">{person.name}</h2>
                  <p className="text-sm text-gray-600 mb-1">{person.title}</p>
                  <p className="text-sm font-medium text-ecofor-turquoise mb-2">{person.organization}</p>
                  <p className="text-sm">{person.bio}</p>
                </div>
              </div>
            ))}
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default Collaborators;
