
import { Link } from "react-router-dom";
import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";
import SectionHeading from "@/components/common/SectionHeading";

const WorkPackages = () => {
  // Liste complète des Work Packages de 0 à 4
  const workPackages = [
    {
      id: "wp0",
      number: "0",
      title: "Coordination",
      description: "Coordination globale du projet et gestion administrative",
      color: "forestt-primary",
      image: "/lovable-uploads/628d6d80-8c84-49a6-97dd-2afb79ccae70.png",
    },
    {
      id: "wp1",
      number: "1",
      title: "Connaissances et formation",
      description: "Synthétiser et diffuser les connaissances sur les forêts et leur gestion",
      color: "forestt-secondary",
      image: "/lovable-uploads/628d6d80-8c84-49a6-97dd-2afb79ccae70.png",
    },
    {
      id: "wp2",
      number: "2",
      title: "Écosystèmes et transitions",
      description: "Analyser les écosystèmes forestiers face aux changements globaux",
      color: "forestt-highlight",
      image: "/lovable-uploads/628d6d80-8c84-49a6-97dd-2afb79ccae70.png",
    },
    {
      id: "wp3",
      number: "3",
      title: "Innovations et technologies",
      description: "Développer des solutions innovantes pour le suivi et la gestion des forêts",
      color: "forestt-accent",
      image: "/lovable-uploads/628d6d80-8c84-49a6-97dd-2afb79ccae70.png",
    },
    {
      id: "wp4",
      number: "4",
      title: "Communication et valorisation",
      description: "Diffuser les résultats et sensibiliser aux enjeux forestiers",
      color: "forestt-primary",
      image: "/lovable-uploads/628d6d80-8c84-49a6-97dd-2afb79ccae70.png",
    }
  ];

  return (
    <PageLayout>
      <Helmet>
        <title>Work Packages - FORESTT-HUB</title>
        <meta 
          name="description" 
          content="Découvrez les différents Work Packages du projet-ciblé FORESTT-HUB et leurs objectifs spécifiques." 
        />
      </Helmet>

      <section className="pt-32 pb-16">
        <div className="container">
          <SectionHeading 
            title="Work Packages" 
            subtitle="Le projet-ciblé FORESTT-HUB est structuré en 5 work packages complémentaires" 
          />

          <div className="mt-12">
            {/* Première ligne : WP 0, 1, 2 */}
            <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
              {workPackages.slice(0, 3).map((wp) => (
                <Link 
                  key={wp.id} 
                  to={`/about/work-packages/${wp.id}`} 
                  className="bg-white rounded-xl shadow-md overflow-hidden transition-transform hover:scale-[1.02] hover:shadow-lg"
                >
                  <div 
                    className={`h-40 relative overflow-hidden`}
                  >
                    <div className={`absolute inset-0 bg-${wp.color} opacity-70 z-10`}></div>
                    <img 
                      src={wp.image}
                      alt={`Work Package ${wp.number}`}
                      className="w-full h-full object-cover"
                    />
                    <div className="absolute top-4 left-4 z-20 flex items-center justify-center w-10 h-10 rounded-full bg-white">
                      <span className={`text-xl font-bold text-${wp.color}`}>{wp.number}</span>
                    </div>
                  </div>
                  
                  <div className="p-6">
                    <h3 className="text-xl font-bold mb-2">{wp.title}</h3>
                    <p className="text-muted-foreground">{wp.description}</p>
                  </div>
                </Link>
              ))}
            </div>
            
            {/* Deuxième ligne : WP 3 et 4 centrés */}
            <div className="flex justify-center">
              <div className="grid grid-cols-1 md:grid-cols-2 gap-6 max-w-2xl">
                {workPackages.slice(3, 5).map((wp) => (
                  <Link 
                    key={wp.id} 
                    to={`/about/work-packages/${wp.id}`} 
                    className="bg-white rounded-xl shadow-md overflow-hidden transition-transform hover:scale-[1.02] hover:shadow-lg"
                  >
                    <div 
                      className={`h-40 relative overflow-hidden`}
                    >
                      <div className={`absolute inset-0 bg-${wp.color} opacity-70 z-10`}></div>
                      <img 
                        src={wp.image}
                        alt={`Work Package ${wp.number}`}
                        className="w-full h-full object-cover"
                      />
                      <div className="absolute top-4 left-4 z-20 flex items-center justify-center w-10 h-10 rounded-full bg-white">
                        <span className={`text-xl font-bold text-${wp.color}`}>{wp.number}</span>
                      </div>
                    </div>
                    
                    <div className="p-6">
                      <h3 className="text-xl font-bold mb-2">{wp.title}</h3>
                      <p className="text-muted-foreground">{wp.description}</p>
                    </div>
                  </Link>
                ))}
              </div>
            </div>
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default WorkPackages;
