
import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";
import { Network } from "lucide-react";

const LivingLabs = () => {
  return (
    <PageLayout>
      <Helmet>
        <title>Living Labs Forestiers - FORESTT-HUB</title>
        <meta name="description" content="Informations sur les Living Labs forestiers du projet FORESTT-HUB, des espaces d'innovation ouverte ancrés dans les territoires." />
      </Helmet>
      
      <section className="py-16">
        <div className="container">
          <div className="flex flex-col items-center mb-8 text-center">
            <Network className="w-16 h-16 text-forestt-primary mb-4" />
            <h1 className="text-center text-4xl font-bold md:text-5xl text-ecofor-dark-green">
              Living Labs Forestiers
            </h1>
          </div>
          
          <div className="max-w-3xl mx-auto">
            <p className="text-lg mb-8">
              Le projet-ciblé FORESTT-HUB développe des Living Labs forestiers, des espaces d'innovation ouverte ancrés dans les territoires qui rassemblent chercheurs, gestionnaires, collectivités et citoyens.
            </p>

            <div className="bg-white border border-gray-200 rounded-lg p-6 mb-8 shadow-sm">
              <h2 className="text-2xl font-semibold mb-4 text-forestt-primary">En cours de développement</h2>
              <p>
                Cette page est en cours de construction. Les informations détaillées sur les Living Labs forestiers seront disponibles prochainement.
              </p>
            </div>
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default LivingLabs;
