
import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";
import { Network } from "lucide-react";

const ReseauxFormation = () => {
  return (
    <PageLayout>
      <Helmet>
        <title>Réseaux de Formation - FORESTT-HUB</title>
        <meta name="description" content="Informations sur les réseaux de formation du projet FORESTT-HUB pour le développement des compétences dans le domaine forestier." />
      </Helmet>
      
      <section className="py-16">
        <div className="container">
          <div className="flex flex-col items-center mb-8 text-center">
            <Network className="w-16 h-16 text-forestt-primary mb-4" />
            <h1 className="text-center text-4xl font-bold md:text-5xl text-ecofor-dark-green">
              Réseaux de Formation
            </h1>
          </div>
          
          <div className="max-w-3xl mx-auto">
            <p className="text-lg mb-8">
              Le projet-ciblé FORESTT-HUB développe des réseaux de formation pour renforcer les compétences et favoriser les échanges entre les acteurs du secteur forestier.
            </p>

            <div className="bg-white border border-gray-200 rounded-lg p-6 mb-8 shadow-sm">
              <h2 className="text-2xl font-semibold mb-4 text-forestt-primary">En cours de développement</h2>
              <p>
                Cette page est en cours de construction. Les informations détaillées sur les réseaux de formation seront disponibles prochainement.
              </p>
            </div>
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default ReseauxFormation;
