
import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";
import { Webcam } from "lucide-react";

const Webinaires = () => {
  return (
    <PageLayout>
      <Helmet>
        <title>Webinaires - FORESTT-HUB</title>
        <meta name="description" content="Programme de webinaires organisés par le projet FORESTT-HUB sur les thématiques forestières et la résilience des écosystèmes." />
      </Helmet>
      
      <section className="py-16">
        <div className="container">
          <div className="flex flex-col items-center mb-8 text-center">
            <Webcam className="w-16 h-16 text-forestt-primary mb-4" />
            <h1 className="text-center text-4xl font-bold md:text-5xl text-ecofor-dark-green">
              Webinaires
            </h1>
          </div>
          
          <div className="max-w-3xl mx-auto">
            <p className="text-lg mb-8">
              Le projet-ciblé FORESTT-HUB organise régulièrement des webinaires sur les thématiques liées à la recherche forestière et à la résilience des écosystèmes.
            </p>

            <div className="bg-white border border-gray-200 rounded-lg p-6 mb-8 shadow-sm">
              <h2 className="text-2xl font-semibold mb-4 text-forestt-primary">En cours de développement</h2>
              <p>
                Cette page est en cours de construction. Le programme des webinaires sera disponible prochainement.
              </p>
            </div>
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default Webinaires;
