
import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";
import SectionHeading from "@/components/common/SectionHeading";
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardFooter, CardHeader, CardTitle } from "@/components/ui/card";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Award, Book, Calendar, ExternalLink, GraduationCap, MapPin, Users } from "lucide-react";
import { Link } from "react-router-dom";

const DoctoralSchools = () => {
  const upcomingEvents = [
    {
      id: 1,
      title: "Séminaire doctoral FORESTT-HUB",
      date: "10-11 Février 2024",
      location: "Paris, France",
      description: "Séminaire de deux jours réunissant les doctorants du projet pour des présentations et des discussions sur leurs travaux de recherche.",
      url: "#"
    },
    {
      id: 2,
      title: "Atelier méthodologique : Modélisation forestière",
      date: "15-17 Mars 2024",
      location: "Montpellier, France",
      description: "Formation intensive aux méthodes de modélisation forestière avec applications pratiques sur des cas d'étude.",
      url: "#"
    },
    {
      id: 3,
      title: "École d'été : Télédétection et forêts",
      date: "5-15 Juillet 2024",
      location: "Nancy, France",
      description: "École d'été internationale sur l'utilisation des données de télédétection pour le suivi et la gestion des forêts.",
      url: "#"
    }
  ];

  const currentTheses = [
    {
      id: 1,
      title: "Résilience des forêts mixtes face aux changements climatiques",
      student: "Sophie Martin",
      supervisors: "Dr. Jean Dupont, Dr. Marie Lambert",
      institution: "Université de Montpellier",
      startYear: 2022,
      endYear: 2025,
      description: "Cette thèse examine comment les forêts composées de plusieurs espèces d'arbres répondent aux stress climatiques, en comparaison avec les peuplements monospécifiques."
    },
    {
      id: 2,
      title: "Connectivité écologique des habitats forestiers fragmentés",
      student: "Thomas Leroy",
      supervisors: "Prof. Anne Dubois, Dr. Pierre Martin",
      institution: "AgroParisTech",
      startYear: 2021,
      endYear: 2024,
      description: "Ce projet de recherche étudie les effets de la fragmentation du paysage sur la connectivité écologique des habitats forestiers et ses conséquences sur la biodiversité."
    },
    {
      id: 3,
      title: "Séquestration du carbone dans les sols forestiers méditerranéens",
      student: "Lucie Bernard",
      supervisors: "Dr. François Leclerc, Dr. Claire Moreau",
      institution: "INRAE",
      startYear: 2023,
      endYear: 2026,
      description: "Cette thèse vise à quantifier et modéliser la dynamique du carbone dans les sols forestiers méditerranéens soumis à différents régimes de gestion."
    }
  ];

  return (
    <PageLayout>
      <Helmet>
        <title>Écoles doctorales - FORESTT-HUB</title>
        <meta name="description" content="Programmes doctoraux et formations pour les jeunes chercheurs en sciences forestières." />
      </Helmet>

      <section className="py-12 md:py-16">
        <div className="container">
          <SectionHeading 
            title="Écoles doctorales" 
            subtitle="Formation et accompagnement des jeunes chercheurs en sciences forestières"
          />

          <div className="max-w-3xl mx-auto mb-10 text-center">
            <p className="text-lg mb-6">
              Le projet FORESTT-HUB s'engage à former la prochaine génération de chercheurs en sciences forestières à travers des programmes doctoraux ambitieux et des formations spécialisées.
            </p>
            <div className="flex justify-center gap-4">
              <Link to="/project-materials/global-forest">
                <Button className="flex items-center">
                  <GraduationCap className="mr-2 h-4 w-4" />
                  Initiative Global Forest
                </Button>
              </Link>
              <Button variant="outline">
                <Book className="mr-2 h-4 w-4" />
                Catalogue des formations
              </Button>
            </div>
          </div>

          <Tabs defaultValue="events" className="max-w-4xl mx-auto">
            <TabsList className="grid w-full grid-cols-3">
              <TabsTrigger value="events">Événements</TabsTrigger>
              <TabsTrigger value="theses">Thèses en cours</TabsTrigger>
              <TabsTrigger value="resources">Ressources</TabsTrigger>
            </TabsList>
            
            <TabsContent value="events" className="mt-6">
              <div className="space-y-6">
                {upcomingEvents.map(event => (
                  <Card key={event.id}>
                    <CardHeader>
                      <div className="flex items-center justify-between">
                        <CardTitle>{event.title}</CardTitle>
                        <div className="flex items-center text-muted-foreground">
                          <Calendar className="mr-2 h-4 w-4" />
                          <span>{event.date}</span>
                        </div>
                      </div>
                      <CardDescription className="flex items-center">
                        <MapPin className="mr-2 h-4 w-4" />
                        {event.location}
                      </CardDescription>
                    </CardHeader>
                    <CardContent>
                      <p>{event.description}</p>
                    </CardContent>
                    <CardFooter className="flex justify-between">
                      <Button variant="outline" size="sm">
                        Programme détaillé
                      </Button>
                      <Button size="sm">
                        S'inscrire
                      </Button>
                    </CardFooter>
                  </Card>
                ))}

                <div className="text-center mt-8">
                  <Button variant="outline">
                    Voir tous les événements
                  </Button>
                </div>
              </div>
            </TabsContent>
            
            <TabsContent value="theses" className="mt-6">
              <div className="space-y-8">
                {currentTheses.map(thesis => (
                  <Card key={thesis.id}>
                    <CardHeader className="bg-ecofor-light-blue/20 rounded-t-lg">
                      <CardTitle>{thesis.title}</CardTitle>
                      <CardDescription className="flex flex-col sm:flex-row sm:items-center sm:gap-2 mt-2">
                        <span className="font-medium flex items-center">
                          <Users className="mr-1 h-4 w-4" />
                          {thesis.student}
                        </span>
                        <span className="hidden sm:inline">•</span>
                        <span>{thesis.institution}</span>
                        <span className="hidden sm:inline">•</span>
                        <span>{thesis.startYear}-{thesis.endYear}</span>
                      </CardDescription>
                    </CardHeader>
                    <CardContent className="pt-4">
                      <p className="mb-4">{thesis.description}</p>
                      <div className="text-sm text-muted-foreground">
                        <span className="font-medium">Direction : </span>
                        {thesis.supervisors}
                      </div>
                    </CardContent>
                    <CardFooter>
                      <Button variant="outline" size="sm" className="w-full">
                        Plus d'informations
                      </Button>
                    </CardFooter>
                  </Card>
                ))}
              </div>
            </TabsContent>
            
            <TabsContent value="resources" className="mt-6">
              <Card>
                <CardHeader>
                  <CardTitle>Ressources pour les doctorants</CardTitle>
                  <CardDescription>Documents, outils et conseils pour les jeunes chercheurs</CardDescription>
                </CardHeader>
                <CardContent>
                  <div className="grid gap-4 sm:grid-cols-2">
                    <Button variant="outline" className="h-auto py-4 px-4 justify-start">
                      <div className="flex flex-col items-start text-left">
                        <span className="font-medium flex items-center">
                          <Award className="mr-2 h-4 w-4" /> 
                          Guide du doctorant
                        </span>
                        <span className="text-sm text-muted-foreground mt-1">
                          Conseils méthodologiques et pratiques
                        </span>
                      </div>
                    </Button>
                    
                    <Button variant="outline" className="h-auto py-4 px-4 justify-start">
                      <div className="flex flex-col items-start text-left">
                        <span className="font-medium flex items-center">
                          <Book className="mr-2 h-4 w-4" /> 
                          Bibliographie partagée
                        </span>
                        <span className="text-sm text-muted-foreground mt-1">
                          Références essentielles en sciences forestières
                        </span>
                      </div>
                    </Button>
                    
                    <Button variant="outline" className="h-auto py-4 px-4 justify-start">
                      <div className="flex flex-col items-start text-left">
                        <span className="font-medium flex items-center">
                          <ExternalLink className="mr-2 h-4 w-4" /> 
                          Opportunités de financement
                        </span>
                        <span className="text-sm text-muted-foreground mt-1">
                          Bourses et aides à la mobilité
                        </span>
                      </div>
                    </Button>
                    
                    <Button variant="outline" className="h-auto py-4 px-4 justify-start">
                      <div className="flex flex-col items-start text-left">
                        <span className="font-medium flex items-center">
                          <GraduationCap className="mr-2 h-4 w-4" /> 
                          Offres de thèses
                        </span>
                        <span className="text-sm text-muted-foreground mt-1">
                          Sujets proposés et conditions de candidature
                        </span>
                      </div>
                    </Button>
                  </div>
                </CardContent>
              </Card>
            </TabsContent>
          </Tabs>
        </div>
      </section>

      <section className="py-12 bg-ecofor-light-blue/10">
        <div className="container">
          <div className="max-w-3xl mx-auto text-center">
            <h2 className="text-2xl font-bold mb-6">Réseau doctoral FORESTT-HUB</h2>
            <p className="mb-8">
              Rejoignez notre réseau de doctorants travaillant sur les questions forestières pour partager vos expériences et développer des collaborations.
            </p>
            <div className="flex justify-center gap-4 flex-wrap">
              <Button>
                Rejoindre le réseau
              </Button>
              <Link to="/contact">
                <Button variant="outline">
                  Contacter les coordinateurs
                </Button>
              </Link>
            </div>
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default DoctoralSchools;
