
import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";
import SectionHeading from "@/components/common/SectionHeading";
import { Button } from "@/components/ui/button";
import { Card, CardContent, CardDescription, CardFooter, CardHeader, CardTitle } from "@/components/ui/card";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Calendar, Download, FileText, Globe, Users } from "lucide-react";
import { Link } from "react-router-dom";

const GlobalForest = () => {
  return (
    <PageLayout>
      <Helmet>
        <title>Global Forest - FORESTT-HUB</title>
        <meta name="description" content="Initiative Global Forest - Un programme international pour la recherche et l'éducation forestière." />
      </Helmet>

      <section className="py-12 md:py-16">
        <div className="container">
          <SectionHeading 
            title="Global Forest" 
            subtitle="Une initiative internationale pour la recherche et l'éducation forestière"
          />

          <div className="max-w-3xl mx-auto mb-10 text-center">
            <p className="text-lg mb-6">
              L'initiative Global Forest rassemble des chercheurs, des praticiens et des étudiants du monde entier pour collaborer sur des projets de recherche forestière et développer des programmes éducatifs innovants.
            </p>
            <div className="flex justify-center gap-4">
              <Button>
                <Download className="mr-2 h-4 w-4" />
                Télécharger la brochure
              </Button>
              <Button variant="outline">
                <Globe className="mr-2 h-4 w-4" />
                Site Global Forest
              </Button>
            </div>
          </div>

          <Tabs defaultValue="overview" className="max-w-4xl mx-auto">
            <TabsList className="grid w-full grid-cols-3">
              <TabsTrigger value="overview">Présentation</TabsTrigger>
              <TabsTrigger value="programs">Programmes</TabsTrigger>
              <TabsTrigger value="events">Événements</TabsTrigger>
            </TabsList>
            
            <TabsContent value="overview" className="mt-6">
              <Card>
                <CardHeader>
                  <CardTitle>À propos de Global Forest</CardTitle>
                  <CardDescription>Une initiative internationale pour l'avenir des forêts</CardDescription>
                </CardHeader>
                <CardContent className="space-y-4">
                  <p>
                    Lancée en 2020, l'initiative Global Forest est un réseau international qui vise à promouvoir la recherche collaborative et l'éducation dans le domaine forestier. Cette initiative s'inscrit dans le cadre des efforts mondiaux pour répondre aux défis environnementaux actuels et futurs.
                  </p>
                  <p>
                    Global Forest facilite les échanges entre chercheurs, professionnels et étudiants de différents pays, offrant ainsi une plateforme unique pour partager des connaissances, développer des compétences et créer des solutions innovantes pour la gestion durable des forêts.
                  </p>
                  <p>
                    Le programme est structuré autour de trois piliers principaux : la recherche collaborative, l'éducation et la formation, et le transfert de connaissances vers les politiques publiques et la pratique.
                  </p>
                </CardContent>
              </Card>
            </TabsContent>
            
            <TabsContent value="programs" className="mt-6">
              <div className="grid gap-6 sm:grid-cols-2">
                <Card>
                  <CardHeader className="bg-ecofor-light-blue/30 rounded-t-lg">
                    <CardTitle className="flex items-center">
                      <FileText className="mr-2 h-5 w-5 text-ecofor-dark-green" />
                      Programme doctoral
                    </CardTitle>
                  </CardHeader>
                  <CardContent className="pt-6">
                    <p className="mb-4">
                      Le programme doctoral Global Forest offre des opportunités de recherche internationales pour les doctorants travaillant sur des questions forestières.
                    </p>
                    <ul className="list-disc pl-5 space-y-2 text-muted-foreground">
                      <li>Financement de mobilités doctorales</li>
                      <li>Co-encadrement international</li>
                      <li>Écoles d'été thématiques</li>
                    </ul>
                  </CardContent>
                  <CardFooter>
                    <Button variant="outline" size="sm" className="w-full">
                      En savoir plus
                    </Button>
                  </CardFooter>
                </Card>
                
                <Card>
                  <CardHeader className="bg-ecofor-light-blue/30 rounded-t-lg">
                    <CardTitle className="flex items-center">
                      <Users className="mr-2 h-5 w-5 text-ecofor-dark-green" />
                      Réseau de recherche
                    </CardTitle>
                  </CardHeader>
                  <CardContent className="pt-6">
                    <p className="mb-4">
                      Un réseau international de chercheurs et d'institutions travaillant sur des projets collaboratifs dans le domaine forestier.
                    </p>
                    <ul className="list-disc pl-5 space-y-2 text-muted-foreground">
                      <li>Projets de recherche transnationaux</li>
                      <li>Partage de données et de méthodologies</li>
                      <li>Publications conjointes</li>
                    </ul>
                  </CardContent>
                  <CardFooter>
                    <Button variant="outline" size="sm" className="w-full">
                      Voir les projets
                    </Button>
                  </CardFooter>
                </Card>
              </div>
            </TabsContent>
            
            <TabsContent value="events" className="mt-6">
              <div className="space-y-6">
                <Card>
                  <CardHeader>
                    <div className="flex items-center justify-between">
                      <CardTitle>École d'été Global Forest 2024</CardTitle>
                      <div className="flex items-center text-muted-foreground">
                        <Calendar className="mr-2 h-4 w-4" />
                        <span>5-15 Juillet 2024</span>
                      </div>
                    </div>
                    <CardDescription>Nancy, France</CardDescription>
                  </CardHeader>
                  <CardContent>
                    <p>
                      L'école d'été 2024 portera sur les défis de la gestion forestière face aux changements globaux, avec des cours, des ateliers et des visites de terrain.
                    </p>
                  </CardContent>
                  <CardFooter className="flex justify-between">
                    <Button variant="outline" size="sm">Programme</Button>
                    <Button size="sm">S'inscrire</Button>
                  </CardFooter>
                </Card>
                
                <Card>
                  <CardHeader>
                    <div className="flex items-center justify-between">
                      <CardTitle>Webinaire mensuel</CardTitle>
                      <div className="flex items-center text-muted-foreground">
                        <Calendar className="mr-2 h-4 w-4" />
                        <span>Dernier jeudi du mois</span>
                      </div>
                    </div>
                    <CardDescription>En ligne</CardDescription>
                  </CardHeader>
                  <CardContent>
                    <p>
                      Série de webinaires présentant les dernières recherches et innovations dans le domaine forestier, avec des intervenants internationaux.
                    </p>
                  </CardContent>
                  <CardFooter className="flex justify-between">
                    <Button variant="outline" size="sm">Calendrier</Button>
                    <Button size="sm">S'inscrire</Button>
                  </CardFooter>
                </Card>
              </div>
            </TabsContent>
          </Tabs>
        </div>
      </section>
      
      <section className="py-12 bg-ecofor-light-blue/10">
        <div className="container">
          <div className="max-w-3xl mx-auto text-center">
            <h2 className="text-2xl font-bold mb-6">Rejoignez le réseau Global Forest</h2>
            <p className="mb-8">
              Que vous soyez chercheur, étudiant ou professionnel du secteur forestier, rejoignez notre communauté internationale pour contribuer à l'avenir des forêts.
            </p>
            <div className="flex justify-center gap-4">
              <Button>
                Devenir membre
              </Button>
              <Link to="/contact">
                <Button variant="outline">
                  Nous contacter
                </Button>
              </Link>
            </div>
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default GlobalForest;
