
import { useState } from "react";
import { Helmet } from "react-helmet-async";
import { Download } from "lucide-react";
import PageLayout from "@/components/layout/PageLayout";
import SectionHeading from "@/components/common/SectionHeading";
import { Button } from "@/components/ui/button";
import DataList from "@/components/resources/DataList";

const Data = () => {
  const [selectedCategory, setSelectedCategory] = useState("all");
  
  const categories = [
    { id: "all", label: "Toutes les données" },
    { id: "climate", label: "Données climatiques" },
    { id: "biodiversity", label: "Biodiversité" },
    { id: "soil", label: "Sols forestiers" },
    { id: "socioeconomic", label: "Données socio-économiques" }
  ];

  return (
    <PageLayout>
      <Helmet>
        <title>Données - FORESTT-HUB</title>
        <meta 
          name="description" 
          content="Accédez aux données produites par le projet-ciblé FORESTT-HUB et découvrez notre politique de gestion des données ouvertes." 
        />
      </Helmet>
      
      <section className="pt-32 pb-16">
        <div className="container">
          <SectionHeading 
            title="Données" 
            subtitle="Accédez aux jeux de données produits dans le cadre du projet-ciblé FORESTT-HUB" 
          />
          
          <div className="mt-8 bg-white p-6 rounded-lg shadow-md">
            <h3 className="text-xl font-semibold mb-4">Notre engagement pour la science ouverte</h3>
            <p className="mb-6">
              Le projet-ciblé FORESTT-HUB s'engage dans une démarche de science ouverte pour permettre 
              un accès libre et équitable aux connaissances scientifiques. Nos jeux de données 
              sont mis à disposition selon les principes FAIR (Faciles à trouver, Accessibles, 
              Interopérables et Réutilisables).
            </p>
            <div className="flex justify-center sm:justify-start">
              <Button variant="outline" className="flex items-center gap-2">
                <Download className="h-4 w-4" />
                <span>Télécharger notre Plan de gestion de données (PGD)</span>
              </Button>
            </div>
          </div>
          
          <div className="mt-12">
            <div className="flex flex-wrap gap-2 mb-6">
              {categories.map((category) => (
                <button 
                  key={category.id}
                  className={`px-4 py-2 rounded-full text-sm font-medium transition-colors ${
                    selectedCategory === category.id 
                      ? 'bg-forestt-primary text-white' 
                      : 'bg-forestt-primary/10 text-forestt-primary hover:bg-forestt-primary/20'
                  }`}
                  onClick={() => setSelectedCategory(category.id)}
                >
                  {category.label}
                </button>
              ))}
            </div>
            
            <DataList category={selectedCategory} />
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default Data;
