
import { useState } from "react";
import { Helmet } from "react-helmet-async";
import PageLayout from "@/components/layout/PageLayout";
import SectionHeading from "@/components/common/SectionHeading";
import DeliverablesList from "@/components/resources/DeliverablesList";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";

const Deliverables = () => {
  const [activeTab, setActiveTab] = useState("all");

  return (
    <PageLayout>
      <Helmet>
        <title>Livrables - FORESTT-HUB</title>
        <meta 
          name="description" 
          content="Explorez les livrables du projet-ciblé FORESTT-HUB, organisés par Work Package et disponibles au téléchargement." 
        />
      </Helmet>
      
      <section className="pt-32 pb-16">
        <div className="container">
          <SectionHeading 
            title="Livrables" 
            subtitle="Découvrez tous les livrables produits dans le cadre du projet-ciblé FORESTT-HUB" 
          />
          
          <div className="mt-12">
            <Tabs defaultValue="all" value={activeTab} onValueChange={setActiveTab} className="w-full">
              <div className="border-b mb-8">
                <TabsList className="mb-[-1px]">
                  <TabsTrigger value="all" className="tab">Tous</TabsTrigger>
                  <TabsTrigger value="wp0" className="tab">WP0</TabsTrigger>
                  <TabsTrigger value="wp1" className="tab">WP1</TabsTrigger>
                  <TabsTrigger value="wp2" className="tab">WP2</TabsTrigger>
                  <TabsTrigger value="wp3" className="tab">WP3</TabsTrigger>
                  <TabsTrigger value="wp4" className="tab">WP4</TabsTrigger>
                </TabsList>
              </div>

              <TabsContent value="all">
                <DeliverablesList filter="all" />
              </TabsContent>
              <TabsContent value="wp0">
                <DeliverablesList filter="wp0" />
              </TabsContent>
              <TabsContent value="wp1">
                <DeliverablesList filter="wp1" />
              </TabsContent>
              <TabsContent value="wp2">
                <DeliverablesList filter="wp2" />
              </TabsContent>
              <TabsContent value="wp3">
                <DeliverablesList filter="wp3" />
              </TabsContent>
              <TabsContent value="wp4">
                <DeliverablesList filter="wp4" />
              </TabsContent>
            </Tabs>
          </div>
        </div>
      </section>
    </PageLayout>
  );
};

export default Deliverables;
