
import { SearchResult } from "@/types/search";

// Données fictives pour simuler une recherche - à remplacer par de vraies données
const newsItems: SearchResult[] = [
  {
    id: 1,
    title: "Publication de l'étude sur l'impact du changement climatique sur les forêts méditerranéennes",
    description: "Cette étude révolutionnaire met en lumière les effets spécifiques du changement climatique sur les forêts méditerranéennes.",
    type: "news",
    date: "28 Septembre 2023",
    url: "/news",
    image: "https://images.unsplash.com/photo-1502082553048-f009c37129b9?ixlib=rb-4.0.3"
  },
  {
    id: 2,
    title: "Conférence internationale sur les forêts méditerranéennes",
    description: "Une conférence réunissant experts et chercheurs pour discuter des défis spécifiques aux forêts méditerranéennes.",
    type: "news",
    date: "15 Octobre 2023",
    url: "/news",
    image: "https://images.unsplash.com/photo-1475721027785-f74eccf877e2?ixlib=rb-4.0.3"
  }
];

const resources: SearchResult[] = [
  {
    id: 1,
    title: "Rapport annuel 2023 sur l'état des forêts en France",
    description: "Une analyse complète de l'état actuel des forêts françaises et des défis à venir.",
    type: "resources",
    date: "Décembre 2023",
    url: "/resources",
    image: ""
  },
  {
    id: 2,
    title: "Impact du changement climatique sur les forêts méditerranéennes",
    description: "Publication scientifique sur les effets du changement climatique dans la région méditerranéenne.",
    type: "resources",
    date: "Octobre 2023",
    url: "/resources",
    image: ""
  }
];

const aboutItems: SearchResult[] = [
  {
    id: "about-presentation",
    title: "Présentation du projet",
    description: "Découvrez les objectifs et la méthodologie du projet GIP Ecofor.",
    type: "about",
    url: "/about/presentation",
    image: ""
  },
  {
    id: "about-partners",
    title: "Partenaires",
    description: "Découvrez les partenaires du projet GIP Ecofor.",
    type: "about",
    url: "/about/partners",
    image: ""
  }
];

const projectMaterials: SearchResult[] = [
  {
    id: "doctoral-schools",
    title: "Écoles doctorales",
    description: "Informations sur les écoles doctorales affiliées au projet.",
    type: "project-materials",
    url: "/project-materials/doctoral-schools",
    image: ""
  },
  {
    id: "global-forest",
    title: "Global Forest",
    description: "Étude globale sur les forêts et leur impact environnemental.",
    type: "project-materials",
    url: "/project-materials/global-forest",
    image: ""
  }
];

// Fusionner toutes les données
const allData: SearchResult[] = [
  ...newsItems,
  ...resources,
  ...aboutItems,
  ...projectMaterials
];

export const searchGlobal = (query: string): SearchResult[] => {
  if (!query.trim()) return [];
  
  const normalizedQuery = query.toLowerCase().trim();
  
  return allData.filter(item => {
    return (
      item.title.toLowerCase().includes(normalizedQuery) ||
      (item.description && item.description.toLowerCase().includes(normalizedQuery))
    );
  });
};

export const getTypeLabel = (type: string): string => {
  switch (type) {
    case 'news':
      return 'Actualités';
    case 'resources':
      return 'Ressources';
    case 'about':
      return 'À propos';
    case 'project-materials':
      return 'Matériels du projet';
    default:
      return type;
  }
};
