import type { Config } from "tailwindcss";

export default {
  darkMode: ["class"],
  content: [
    "./pages/**/*.{ts,tsx}",
    "./components/**/*.{ts,tsx}",
    "./app/**/*.{ts,tsx}",
    "./src/**/*.{ts,tsx}",
  ],
  prefix: "",
  theme: {
    container: {
      center: true,
      padding: '2rem',
      screens: {
        sm: '640px',
        md: '768px',
        lg: '1024px',
        xl: '1280px',
        '2xl': '1400px'
      }
    },
    extend: {
      fontFamily: {
        sans: ['Marianne', 'Arial', 'sans-serif'],
        serif: ['Times New Roman', 'serif'],
        display: ['Marianne', 'Arial', 'sans-serif'],
        marianne: ['Marianne', 'Arial', 'sans-serif'],
      },
      colors: {
        border: 'hsl(var(--border))',
        input: 'hsl(var(--input))',
        ring: 'hsl(var(--ring))',
        background: 'hsl(var(--background))',
        foreground: 'hsl(var(--foreground))',
        forestt: {
          'primary': '#46724B',      // Couleur principale (R70, G114, B75)
          'secondary': '#68A532',    // Couleur secondaire (R104, G165, B50)
          'accent': '#000091',       // Couleur d'accent (R0, G0, B145)
          'highlight': '#99C221',    // Couleur de mise en valeur (R153, G194, B33)
          'primary-10': 'rgba(70, 114, 75, 0.1)',
          'primary-25': 'rgba(70, 114, 75, 0.25)',
          'primary-50': 'rgba(70, 114, 75, 0.5)',
          'secondary-10': 'rgba(104, 165, 50, 0.1)',
          'secondary-25': 'rgba(104, 165, 50, 0.25)',
          'secondary-50': 'rgba(104, 165, 50, 0.5)',
          'accent-10': 'rgba(0, 0, 145, 0.1)',
          'accent-25': 'rgba(0, 0, 145, 0.25)',
          'accent-50': 'rgba(0, 0, 145, 0.5)',
          'highlight-10': 'rgba(153, 194, 33, 0.1)',
          'highlight-25': 'rgba(153, 194, 33, 0.25)',
          'highlight-50': 'rgba(153, 194, 33, 0.5)',
        },
        ecofor: {
          'light-blue': '#feffff', 
          'medium-blue': '#cfedf0', 
          'turquoise': '#87d0d6', 
          'dark-green': '#46724B', // Remplacé par la couleur principale FORESTT
        },
        primary: {
          DEFAULT: 'hsl(var(--primary))',
          foreground: 'hsl(var(--primary-foreground))'
        },
        secondary: {
          DEFAULT: 'hsl(var(--secondary))',
          foreground: 'hsl(var(--secondary-foreground))'
        },
        destructive: {
          DEFAULT: 'hsl(var(--destructive))',
          foreground: 'hsl(var(--destructive-foreground))'
        },
        muted: {
          DEFAULT: 'hsl(var(--muted))',
          foreground: 'hsl(var(--muted-foreground))'
        },
        accent: {
          DEFAULT: 'hsl(var(--accent))',
          foreground: 'hsl(var(--accent-foreground))'
        },
        popover: {
          DEFAULT: 'hsl(var(--popover))',
          foreground: 'hsl(var(--popover-foreground))'
        },
        card: {
          DEFAULT: 'hsl(var(--card))',
          foreground: 'hsl(var(--card-foreground))'
        },
        sidebar: {
          DEFAULT: 'hsl(var(--sidebar-background))',
          foreground: 'hsl(var(--sidebar-foreground))',
          primary: 'hsl(var(--sidebar-primary))',
          'primary-foreground': 'hsl(var(--sidebar-primary-foreground))',
          accent: 'hsl(var(--sidebar-accent))',
          'accent-foreground': 'hsl(var(--sidebar-accent-foreground))',
          border: 'hsl(var(--sidebar-border))',
          ring: 'hsl(var(--sidebar-ring))'
        }
      },
      borderRadius: {
        lg: 'var(--radius)',
        md: 'calc(var(--radius) - 2px)',
        sm: 'calc(var(--radius) - 4px)'
      },
      keyframes: {
        'accordion-down': {
          from: { height: '0' },
          to: { height: 'var(--radix-accordion-content-height)' }
        },
        'accordion-up': {
          from: { height: 'var(--radix-accordion-content-height)' },
          to: { height: '0' }
        },
        fadeIn: {
          '0%': { opacity: '0' },
          '100%': { opacity: '1' }
        },
        slideUp: {
          '0%': { transform: 'translateY(20px)', opacity: '0' },
          '100%': { transform: 'translateY(0)', opacity: '1' }
        },
        slideInLeft: {
          '0%': { transform: 'translateX(-20px)', opacity: '0' },
          '100%': { transform: 'translateX(0)', opacity: '1' }
        },
        pulse: {
          '0%, 100%': { opacity: '1' },
          '50%': { opacity: '0.7' }
        }
      },
      animation: {
        'accordion-down': 'accordion-down 0.2s ease-out',
        'accordion-up': 'accordion-up 0.2s ease-out',
        'fade-in': 'fadeIn 0.6s ease-out forwards',
        'slide-up': 'slideUp 0.6s ease-out forwards',
        'slide-in-left': 'slideInLeft 0.6s ease-out forwards',
        'pulse-slow': 'pulse 4s infinite'
      }
    }
  },
  plugins: [require("tailwindcss-animate")],
} satisfies Config;
