
# Guide d'implémentation WordPress pour Forestt-Hub

Ce guide explique comment configurer votre installation WordPress pour qu'elle fonctionne avec l'application React Forestt-Hub.

## 1. Installation et configuration de base de WordPress

### Installation de WordPress
1. Téléchargez et installez WordPress sur votre serveur web.
2. Complétez le processus d'installation initial en créant une base de données et un compte administrateur.

### Configuration de base
1. Accédez à l'administration WordPress : https://forestt-hub.gip-ecofor.org/wp-admin/
2. Allez dans Réglages > Permaliens et sélectionnez "Titre de la publication" pour obtenir des URLs propres.

## 2. Installation des plugins nécessaires

Les plugins suivants sont recommandés pour une intégration optimale avec l'application React:

### Plugins essentiels
- **JWT Authentication for WP REST API** : Pour la sécurisation de l'API
- **Custom Post Type UI** : Pour créer des types de contenu personnalisés
- **Advanced Custom Fields** : Pour ajouter des champs personnalisés
- **WP REST API Menus** : Pour exposer les menus via l'API REST
- **Yoast SEO** : Pour le référencement

### Étapes d'installation
1. Dans le menu WordPress, naviguez vers Extensions > Ajouter
2. Recherchez et installez chaque plugin mentionné ci-dessus
3. Activez tous les plugins installés

## 3. Configuration de l'API REST

### Activation et sécurisation de l'API REST
1. Configurer JWT Authentication en ajoutant dans votre fichier wp-config.php:
   ```php
   define('JWT_AUTH_SECRET_KEY', 'votre-clé-secrète-unique');
   define('JWT_AUTH_CORS_ENABLE', true);
   ```

2. Configuration CORS pour permettre les requêtes depuis votre application React:
   - Ajoutez les règles CORS dans votre fichier .htaccess (voir fichier cors-settings-for-wordpress.htaccess)

## 4. Création des types de contenu personnalisés

Utilisez Custom Post Type UI pour créer les types de contenu suivants:

### Événements
- Libellé: Événements
- Slug: evenements
- Supporte: titre, éditeur, image à la une

### Téléchargements
- Libellé: Téléchargements
- Slug: telecharger
- Supporte: titre, éditeur, image à la une

### Partenaires
- Libellé: Partenaires
- Slug: partenaires
- Supporte: titre, éditeur, image à la une

## 5. Configuration des champs personnalisés (ACF)

Utilisez Advanced Custom Fields pour ajouter des champs supplémentaires:

### Pour les Événements
- Date de l'événement (type date)
- Lieu (type texte)
- Lien d'inscription (type URL)

### Pour les Téléchargements
- Fichier à télécharger (type fichier)
- Type de document (type sélection: Livrable, Publication, Présentation, Autre)

### Pour les Partenaires
- Logo (type image)
- Site web (type URL)
- Localisation (type texte)
- Type de partenaire (type sélection: Académique, Industriel, Institutionnel)

## 6. Exposer les champs personnalisés via l'API REST

1. Pour chaque groupe de champs ACF, cochez l'option "Show in REST API"
2. Ajoutez le code suivant dans le fichier functions.php de votre thème:

```php
// Exposer les champs ACF dans l'API REST
function forestt_hub_acf_to_rest_api($response, $post, $request) {
    if (!function_exists('get_fields')) return $response;
    
    if (isset($post)) {
        $acf = get_fields($post->ID);
        if (!empty($acf)) {
            $response->data['acf'] = $acf;
        }
    }
    return $response;
}

add_filter('rest_prepare_post', 'forestt_hub_acf_to_rest_api', 10, 3);
add_filter('rest_prepare_page', 'forestt_hub_acf_to_rest_api', 10, 3);
add_filter('rest_prepare_evenements', 'forestt_hub_acf_to_rest_api', 10, 3);
add_filter('rest_prepare_telecharger', 'forestt_hub_acf_to_rest_api', 10, 3);
add_filter('rest_prepare_partenaires', 'forestt_hub_acf_to_rest_api', 10, 3);
```

## 7. Création des pages principales et de contenu

1. Créez les pages principales qui correspondent à la structure de votre application React:
   - Accueil
   - À propos (avec sous-pages: Présentation du projet, Différents WP, Partenaires, Collaborateurs)
   - Ressources
   - Project Materials (avec sous-pages: Écoles doctorales, Global Forest)
   - Actualités/Événements
   - Contacts

2. Pour chaque page, utilisez le modèle de page approprié si vous avez créé des modèles personnalisés.

## 8. Tester l'intégration

1. Assurez-vous que votre API REST WordPress est accessible en visitant:
   `https://forestt-hub.gip-ecofor.org/wp-json/wp/v2/`

2. Testez la récupération des différents types de contenu:
   - Pages: `https://forestt-hub.gip-ecofor.org/wp-json/wp/v2/pages`
   - Articles: `https://forestt-hub.gip-ecofor.org/wp-json/wp/v2/posts`
   - Événements: `https://forestt-hub.gip-ecofor.org/wp-json/wp/v2/evenements`

## 9. Utilisation du site avec l'application React

Une fois que toutes les configurations sont terminées, votre application React devrait pouvoir:
- Récupérer les contenus depuis l'API WordPress
- Afficher les articles, pages et contenus personnalisés
- Afficher les médias et images

Pour plus d'informations sur l'utilisation de l'API WordPress, consultez:
https://developer.wordpress.org/rest-api/

En cas de problème lors de l'intégration, vérifiez les journaux de votre serveur pour les erreurs CORS ou autres problèmes d'API.

---
Développé par SoftSolutions
