
<?php
/**
 * Le modèle pour afficher le pied de page
 *
 * @package FORESTT-HUB
 */

?>

    </div><!-- #content -->

    <footer id="colophon" class="site-footer">
        <div class="footer-inner">
            <div class="partner-logos">
                <?php
                // Tableau des partenaires avec les logos en ordre alphabétique
                $partners_logos = array(
                    'AgroParisTech' => '/wp-content/themes/forestt-hub/assets/images/partners/AgroParisTech.png',
                    'CIRAD' => '/wp-content/themes/forestt-hub/assets/images/partners/CIRAD.png',
                    'CNRS' => '/wp-content/themes/forestt-hub/assets/images/partners/CNRS_BLEU.png',
                    'ECOFOR' => '/wp-content/themes/forestt-hub/assets/images/partners/ECOFOR.png',
                    'EHESS' => '/wp-content/themes/forestt-hub/assets/images/partners/EHESS_2021_RVB.png',
                    'ENSFEA' => '/wp-content/themes/forestt-hub/assets/images/partners/ENSFEA.png',
                    'INRAE' => '/wp-content/themes/forestt-hub/assets/images/partners/Logo-INRAE_Transparent.png',
                    'Le Mans Université' => '/wp-content/themes/forestt-hub/assets/images/partners/LEMANS_UNIVERSITE-WEB.png',
                    'ONF' => '/wp-content/themes/forestt-hub/assets/images/partners/ONF.png',
                    'Université de Lorraine' => '/wp-content/themes/forestt-hub/assets/images/partners/universite-de-lorraine.png',
                    'Université de Montpellier' => '/wp-content/themes/forestt-hub/assets/images/partners/University_of_Montpellier_logo.png',
                    'Université de Picardie Jules Verne' => '/wp-content/themes/forestt-hub/assets/images/partners/UPJV.png',
                    'Université de Pau et des Pays de l\'Adour' => '/wp-content/themes/forestt-hub/assets/images/partners/UPPA.png',
                    'Université Grenoble Alpes' => '/wp-content/themes/forestt-hub/assets/images/partners/UGA.png',
                    'Université Toulouse 2 Jean Jaurès' => '/wp-content/themes/forestt-hub/assets/images/partners/UT2J.png',
                );

                foreach ($partners_logos as $name => $logo) {
                    // Ajout de classes conditionnelles pour ajuster certains logos
                    $logo_class = 'partner-logo';
                    
                    echo '<div class="partner-logo-wrapper">';
                    echo '<img src="' . esc_url($logo) . '" alt="Logo ' . esc_attr($name) . '" class="' . $logo_class . '">';
                    echo '</div>';
                }
                ?>
            </div>

            <div class="footer-widgets">
                <div class="footer-widget">
                    <h3 class="footer-widget-title"><?php echo esc_html('Résilience des forêts'); ?></h3>
                    <p><?php echo esc_html('Forêts et changements globaux : systèmes socio-écologiques en transition'); ?></p>
                </div>

                <div class="footer-widget">
                    <h3 class="footer-widget-title"><?php echo esc_html('Liens Rapides'); ?></h3>
                    <?php
                    wp_nav_menu(
                        array(
                            'theme_location' => 'footer-menu',
                            'menu_class' => 'footer-menu',
                            'container' => false,
                        )
                    );
                    ?>
                </div>

                <div class="footer-widget">
                    <h3 class="footer-widget-title"><?php echo esc_html('Contact'); ?></h3>
                    <address>
                        <p><strong>GIP ECOFOR</strong><br>
                        42 rue Scheffer<br>
                        75116 Paris, France</p>
                        <p>Téléphone: +33 (0)1 53 70 21 70<br>
                        Email: <a href="mailto:communication@gip-ecofor.fr">communication@gip-ecofor.fr</a></p>
                    </address>
                </div>
            </div>

            <div class="footer-bottom">
                <p>&copy; <?php echo date('Y'); ?> Projet-Ciblé FORESTT-HUB : Think-&-Do Tank. Tous droits réservés.</p>
                <p class="signature">Développé par SoftSolutions</p>
            </div>
        </div>
    </footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
