
<?php
/**
 * Configuration des champs ACF pour le thème FORESTT-HUB
 *
 * @package FORESTT-HUB
 */

if (!function_exists('acf_add_local_field_group')) {
    return;
}

/**
 * Configuration des champs ACF pour les Work Packages
 */
acf_add_local_field_group(array(
    'key' => 'group_work_packages',
    'title' => 'Détails du Work Package',
    'fields' => array(
        array(
            'key' => 'field_wp_id',
            'label' => 'Identifiant WP',
            'name' => 'wp_id',
            'type' => 'text',
            'instructions' => 'Identifiant du Work Package (ex: WP0, WP1, etc.)',
            'required' => 1,
        ),
        array(
            'key' => 'field_wp_lead',
            'label' => 'Responsable',
            'name' => 'wp_lead',
            'type' => 'text',
            'instructions' => 'Nom du responsable du Work Package',
            'required' => 0,
        ),
        array(
            'key' => 'field_wp_tasks',
            'label' => 'Tâches',
            'name' => 'wp_tasks',
            'type' => 'repeater',
            'instructions' => 'Liste des tâches du Work Package',
            'required' => 0,
            'layout' => 'table',
            'sub_fields' => array(
                array(
                    'key' => 'field_wp_task_id',
                    'label' => 'ID Tâche',
                    'name' => 'task_id',
                    'type' => 'text',
                ),
                array(
                    'key' => 'field_wp_task_name',
                    'label' => 'Nom',
                    'name' => 'task_name',
                    'type' => 'text',
                ),
                array(
                    'key' => 'field_wp_task_description',
                    'label' => 'Description',
                    'name' => 'task_description',
                    'type' => 'textarea',
                ),
            ),
        ),
        array(
            'key' => 'field_wp_description',
            'label' => 'Description',
            'name' => 'wp_description',
            'type' => 'wysiwyg',
            'instructions' => 'Description détaillée du Work Package',
            'required' => 0,
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'work_packages',
            ),
        ),
    ),
));

/**
 * Configuration des champs ACF pour les Publications
 */
acf_add_local_field_group(array(
    'key' => 'group_publications',
    'title' => 'Détails de la Publication',
    'fields' => array(
        array(
            'key' => 'field_doi',
            'label' => 'DOI',
            'name' => 'doi',
            'type' => 'text',
            'instructions' => 'Identifiant DOI de la publication',
            'required' => 0,
        ),
        array(
            'key' => 'field_authors',
            'label' => 'Auteurs',
            'name' => 'authors',
            'type' => 'text',
            'instructions' => 'Liste des auteurs',
            'required' => 0,
        ),
        array(
            'key' => 'field_journal',
            'label' => 'Journal',
            'name' => 'journal',
            'type' => 'text',
            'instructions' => 'Nom du journal',
            'required' => 0,
        ),
        array(
            'key' => 'field_publication_date',
            'label' => 'Date de publication',
            'name' => 'publication_date',
            'type' => 'date_picker',
            'instructions' => 'Date de publication',
            'required' => 0,
            'display_format' => 'd/m/Y',
            'return_format' => 'Y-m-d',
        ),
        array(
            'key' => 'field_file_download',
            'label' => 'Fichier à télécharger',
            'name' => 'file_download',
            'type' => 'file',
            'instructions' => 'Fichier PDF de la publication',
            'required' => 0,
            'return_format' => 'url',
        ),
        array(
            'key' => 'field_external_link',
            'label' => 'Lien externe',
            'name' => 'external_link',
            'type' => 'url',
            'instructions' => 'Lien vers la publication en ligne',
            'required' => 0,
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'publications',
            ),
        ),
    ),
));

/**
 * Configuration des champs ACF pour les Présentations
 */
acf_add_local_field_group(array(
    'key' => 'group_presentations',
    'title' => 'Détails de la Présentation',
    'fields' => array(
        array(
            'key' => 'field_pres_authors',
            'label' => 'Présentateurs',
            'name' => 'authors',
            'type' => 'text',
            'instructions' => 'Noms des présentateurs',
            'required' => 0,
        ),
        array(
            'key' => 'field_event_name',
            'label' => 'Nom de l\'événement',
            'name' => 'event_name',
            'type' => 'text',
            'instructions' => 'Nom de l\'événement où la présentation a été faite',
            'required' => 0,
        ),
        array(
            'key' => 'field_presentation_date',
            'label' => 'Date de présentation',
            'name' => 'presentation_date',
            'type' => 'date_picker',
            'instructions' => 'Date de la présentation',
            'required' => 0,
            'display_format' => 'd/m/Y',
            'return_format' => 'Y-m-d',
        ),
        array(
            'key' => 'field_pres_file_download',
            'label' => 'Fichier à télécharger',
            'name' => 'file_download',
            'type' => 'file',
            'instructions' => 'Fichier de la présentation',
            'required' => 0,
            'return_format' => 'url',
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'presentations',
            ),
        ),
    ),
));

/**
 * Configuration des champs ACF pour les Vidéos
 */
acf_add_local_field_group(array(
    'key' => 'group_videos',
    'title' => 'Détails de la Vidéo',
    'fields' => array(
        array(
            'key' => 'field_video_authors',
            'label' => 'Intervenants',
            'name' => 'authors',
            'type' => 'text',
            'instructions' => 'Noms des intervenants',
            'required' => 0,
        ),
        array(
            'key' => 'field_video_date',
            'label' => 'Date de la vidéo',
            'name' => 'video_date',
            'type' => 'date_picker',
            'instructions' => 'Date de la vidéo',
            'required' => 0,
            'display_format' => 'd/m/Y',
            'return_format' => 'Y-m-d',
        ),
        array(
            'key' => 'field_youtube_id',
            'label' => 'ID YouTube',
            'name' => 'youtube_id',
            'type' => 'text',
            'instructions' => 'Identifiant de la vidéo YouTube',
            'required' => 0,
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'videos',
            ),
        ),
    ),
));

/**
 * Configuration des champs ACF pour les Événements
 */
acf_add_local_field_group(array(
    'key' => 'group_evenements',
    'title' => 'Détails de l\'Événement',
    'fields' => array(
        array(
            'key' => 'field_event_date',
            'label' => 'Date de l\'événement',
            'name' => 'event_date',
            'type' => 'date_picker',
            'instructions' => 'Date de début de l\'événement',
            'required' => 1,
            'display_format' => 'd/m/Y',
            'return_format' => 'Y-m-d',
        ),
        array(
            'key' => 'field_event_end_date',
            'label' => 'Date de fin',
            'name' => 'event_end_date',
            'type' => 'date_picker',
            'instructions' => 'Date de fin de l\'événement',
            'required' => 0,
            'display_format' => 'd/m/Y',
            'return_format' => 'Y-m-d',
        ),
        array(
            'key' => 'field_event_location',
            'label' => 'Lieu',
            'name' => 'event_location',
            'type' => 'text',
            'instructions' => 'Lieu de l\'événement',
            'required' => 0,
        ),
        array(
            'key' => 'field_event_type',
            'label' => 'Type d\'événement',
            'name' => 'event_type',
            'type' => 'select',
            'instructions' => 'Type d\'événement',
            'choices' => array(
                'conference' => 'Conférence',
                'workshop' => 'Atelier',
                'seminar' => 'Séminaire',
                'webinar' => 'Webinaire',
                'other' => 'Autre',
            ),
            'default_value' => 'conference',
            'return_format' => 'value',
        ),
        array(
            'key' => 'field_registration_link',
            'label' => 'Lien d\'inscription',
            'name' => 'registration_link',
            'type' => 'url',
            'instructions' => 'Lien d\'inscription à l\'événement',
            'required' => 0,
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'evenements',
            ),
        ),
    ),
));

/**
 * Configuration des champs ACF pour les Téléchargements
 */
acf_add_local_field_group(array(
    'key' => 'group_telecharger',
    'title' => 'Détails du Document',
    'fields' => array(
        array(
            'key' => 'field_download_file',
            'label' => 'Fichier à télécharger',
            'name' => 'file_download',
            'type' => 'file',
            'instructions' => 'Fichier à télécharger',
            'required' => 1,
            'return_format' => 'url',
        ),
        array(
            'key' => 'field_document_type',
            'label' => 'Type de document',
            'name' => 'document_type',
            'type' => 'select',
            'instructions' => 'Type de document',
            'choices' => array(
                'livrable' => 'Livrable',
                'publication' => 'Publication',
                'presentation' => 'Présentation',
                'donnees' => 'Données',
                'autre' => 'Autre',
            ),
            'default_value' => 'livrable',
            'return_format' => 'value',
        ),
        array(
            'key' => 'field_download_authors',
            'label' => 'Auteurs',
            'name' => 'authors',
            'type' => 'text',
            'instructions' => 'Noms des auteurs du document',
            'required' => 0,
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'telecharger',
            ),
        ),
    ),
));

/**
 * Configuration des champs ACF pour les Partenaires
 */
acf_add_local_field_group(array(
    'key' => 'group_partenaires',
    'title' => 'Détails du Partenaire',
    'fields' => array(
        array(
            'key' => 'field_partner_logo',
            'label' => 'Logo',
            'name' => 'partner_logo',
            'type' => 'image',
            'instructions' => 'Logo du partenaire',
            'required' => 0,
            'return_format' => 'url',
        ),
        array(
            'key' => 'field_partner_website',
            'label' => 'Site web',
            'name' => 'partner_website',
            'type' => 'url',
            'instructions' => 'Site web du partenaire',
            'required' => 0,
        ),
        array(
            'key' => 'field_partner_location',
            'label' => 'Localisation',
            'name' => 'partner_location',
            'type' => 'text',
            'instructions' => 'Localisation du partenaire',
            'required' => 0,
        ),
    ),
    'location' => array(
        array(
            array(
                'param' => 'post_type',
                'operator' => '==',
                'value' => 'partenaires',
            ),
        ),
    ),
));
