<?php
/**
 * FORESTT-HUB Theme Customizer
 *
 * @package FORESTT-HUB
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function forestt_customize_register($wp_customize) {
    $wp_customize->get_setting('blogname')->transport = 'postMessage';
    $wp_customize->get_setting('blogdescription')->transport = 'postMessage';
    $wp_customize->get_setting('header_textcolor')->transport = 'postMessage';

    if (isset($wp_customize->selective_refresh)) {
        $wp_customize->selective_refresh->add_partial(
            'blogname',
            array(
                'selector' => '.site-title',
                'render_callback' => 'forestt_customize_partial_blogname',
            )
        );
        $wp_customize->selective_refresh->add_partial(
            'blogdescription',
            array(
                'selector' => '.site-description',
                'render_callback' => 'forestt_customize_partial_blogdescription',
            )
        );
    }

    // Section pour les couleurs du thème
    $wp_customize->add_section('forestt_colors', array(
        'title' => __('Couleurs FORESTT', 'forestt-hub'),
        'priority' => 30,
    ));

    // Couleur primaire
    $wp_customize->add_setting('forestt_primary_color', array(
        'default' => '#2C5F2D',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'forestt_primary_color', array(
        'label' => __('Couleur primaire', 'forestt-hub'),
        'section' => 'forestt_colors',
        'settings' => 'forestt_primary_color',
    )));

    // Couleur secondaire
    $wp_customize->add_setting('forestt_secondary_color', array(
        'default' => '#97BC62',
        'sanitize_callback' => 'sanitize_hex_color',
    ));

    $wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'forestt_secondary_color', array(
        'label' => __('Couleur secondaire', 'forestt-hub'),
        'section' => 'forestt_colors',
        'settings' => 'forestt_secondary_color',
    )));
}
add_action('customize_register', 'forestt_customize_register');

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function forestt_customize_partial_blogname() {
    bloginfo('name');
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function forestt_customize_partial_blogdescription() {
    bloginfo('description');
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function forestt_customize_preview_js() {
    wp_enqueue_script('forestt-customizer', get_template_directory_uri() . '/js/customizer.js', array('customize-preview'), '1.0.0', true);
}
add_action('customize_preview_init', 'forestt_customize_preview_js');