<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package FORESTT-HUB
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function forestt_body_classes($classes) {
    // Adds a class of hfeed to non-singular pages.
    if (!is_singular()) {
        $classes[] = 'hfeed';
    }

    // Adds a class of no-sidebar when there is no sidebar present.
    if (!is_active_sidebar('sidebar-1')) {
        $classes[] = 'no-sidebar';
    }

    return $classes;
}
add_filter('body_class', 'forestt_body_classes');

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function forestt_pingback_header() {
    if (is_singular() && pings_open()) {
        printf('<link rel="pingback" href="%s">', esc_url(get_bloginfo('pingback_url')));
    }
}
add_action('wp_head', 'forestt_pingback_header');

/**
 * Fonction pour afficher les breadcrumbs
 */
function forestt_breadcrumbs() {
    if (is_home() || is_front_page()) {
        return;
    }

    echo '<div class="breadcrumbs">';
    echo '<a href="' . esc_url(home_url('/')) . '">Accueil</a>';
    
    if (is_category() || is_single()) {
        echo ' <span class="separator">/</span> ';
        the_category(' <span class="separator">/</span> ');
        if (is_single()) {
            echo ' <span class="separator">/</span> ';
            the_title();
        }
    } elseif (is_page()) {
        echo ' <span class="separator">/</span> ';
        echo the_title();
    }
    
    echo '</div>';
}

/**
 * Fonction pour limiter le nombre de mots dans un extrait
 */
function forestt_excerpt_length($length) {
    return 25;
}
add_filter('excerpt_length', 'forestt_excerpt_length');

/**
 * Fonction pour changer le texte "Lire la suite"
 */
function forestt_excerpt_more($more) {
    return '...';
}
add_filter('excerpt_more', 'forestt_excerpt_more');

/**
 * Fonction pour formatter la date en français
 */
function forestt_format_date($date) {
    setlocale(LC_TIME, 'fr_FR.UTF-8');
    return strftime('%d %B %Y', strtotime($date));
}

/**
 * Fonction pour récupérer les posts récents par type
 */
function forestt_get_recent_posts($post_type = 'post', $limit = 5) {
    $args = array(
        'post_type' => $post_type,
        'posts_per_page' => $limit,
        'post_status' => 'publish',
        'orderby' => 'date',
        'order' => 'DESC'
    );
    
    return new WP_Query($args);
}

/**
 * Fonction pour récupérer les termes d'une taxonomie
 */
function forestt_get_taxonomy_terms($taxonomy, $post_id = null) {
    if ($post_id) {
        return get_the_terms($post_id, $taxonomy);
    } else {
        return get_terms(array(
            'taxonomy' => $taxonomy,
            'hide_empty' => false,
        ));
    }
}

/**
 * Fonction pour afficher les logos des partenaires
 */
function forestt_display_partner_logos() {
    $partners = array(
        'AgroParisTech' => '/wp-content/themes/forestt-hub/assets/images/partners/AgroParisTech.png',
        'CIRAD' => '/wp-content/themes/forestt-hub/assets/images/partners/CIRAD.png',
        'CNRS' => '/wp-content/themes/forestt-hub/assets/images/partners/CNRS_BLEU.png',
        'ECOFOR' => '/wp-content/themes/forestt-hub/assets/images/partners/ECOFOR.png',
        'EHESS' => '/wp-content/themes/forestt-hub/assets/images/partners/EHESS_2021_RVB.png',
        'ENSFEA' => '/wp-content/themes/forestt-hub/assets/images/partners/ENSFEA.png',
        'INRAE' => '/wp-content/themes/forestt-hub/assets/images/partners/Logo-INRAE_Transparent.png',
        'Le Mans Université' => '/wp-content/themes/forestt-hub/assets/images/partners/LEMANS_UNIVERSITE-WEB.png',
        'ONF' => '/wp-content/themes/forestt-hub/assets/images/partners/ONF.png',
        'Université de Lorraine' => '/wp-content/themes/forestt-hub/assets/images/partners/universite-de-lorraine.png',
        'Université de Montpellier' => '/wp-content/themes/forestt-hub/assets/images/partners/University_of_Montpellier_logo.png',
        'Université de Picardie Jules Verne' => '/wp-content/themes/forestt-hub/assets/images/partners/UPJV.png',
        'Université de Pau et des Pays de l\'Adour' => '/wp-content/themes/forestt-hub/assets/images/partners/UPPA.png',
        'Université Grenoble Alpes' => '/wp-content/themes/forestt-hub/assets/images/partners/UGA.png',
        'Université Toulouse 2 Jean Jaurès' => '/wp-content/themes/forestt-hub/assets/images/partners/UT2J.png',
    );

    echo '<div class="partner-logos">';
    foreach ($partners as $name => $logo) {
        echo '<div class="partner-logo-wrapper">';
        echo '<img src="' . esc_url($logo) . '" alt="Logo ' . esc_attr($name) . '" class="partner-logo">';
        echo '</div>';
    }
    echo '</div>';
}