<?php
/**
 * Template Name: Living Labs forestiers
 * 
 * @package FORESTT-HUB
 */

get_header(); ?>

<div id="primary" class="content-area">
    <main id="main" class="site-main living-labs-page">
        
        <div class="page-header">
            <div class="container">
                <div class="page-breadcrumb">
                    <a href="<?php echo esc_url(home_url('/')); ?>">Accueil</a>
                    <span class="separator">/</span>
                    <a href="<?php echo esc_url(home_url('/activites')); ?>">Activités</a>
                    <span class="separator">/</span>
                    <span class="current">Living Labs forestiers</span>
                </div>
                <h1 class="page-title">Living Labs forestiers</h1>
                <p class="page-description">
                    Espaces d'innovation collaborative pour expérimenter et co-créer des solutions forestières
                </p>
            </div>
        </div>

        <div class="page-content">
            <div class="container">
                <?php
                if (have_posts()) :
                    while (have_posts()) : the_post();
                        the_content();
                    endwhile;
                else :
                    ?>
                    <div class="content-section">
                        <h2>À propos des Living Labs forestiers</h2>
                        <p>
                            Les Living Labs forestiers sont des espaces d'innovation ouverte où les parties prenantes 
                            (chercheurs, gestionnaires forestiers, décideurs, citoyens) collaborent pour développer 
                            et tester des solutions innovantes pour la gestion durable des forêts.
                        </p>
                        
                        <div class="labs-grid">
                            <div class="lab-card">
                                <h3>Lab Innovation Silviculture</h3>
                                <p>Expérimentation de nouvelles techniques sylvicoles adaptées au changement climatique</p>
                                <div class="lab-status">En préparation</div>
                            </div>
                            
                            <div class="lab-card">
                                <h3>Lab Gouvernance Participative</h3>
                                <p>Co-construction de modèles de gouvernance forestière inclusive</p>
                                <div class="lab-status">En préparation</div>
                            </div>
                            
                            <div class="lab-card">
                                <h3>Lab Biodiversité</h3>
                                <p>Développement d'outils de monitoring et de conservation de la biodiversité forestière</p>
                                <div class="lab-status">En préparation</div>
                            </div>
                        </div>
                    </div>
                    <?php
                endif;
                ?>
            </div>
        </div>

    </main><!-- #main -->
</div><!-- #primary -->

<?php
get_footer();
?>