<?php
/**
 * Template Name: Réseaux de formation
 * 
 * @package FORESTT-HUB
 */

get_header(); ?>

<div id="primary" class="content-area">
    <main id="main" class="site-main reseaux-formation-page">
        
        <div class="page-header">
            <div class="container">
                <div class="page-breadcrumb">
                    <a href="<?php echo esc_url(home_url('/')); ?>">Accueil</a>
                    <span class="separator">/</span>
                    <a href="<?php echo esc_url(home_url('/activites')); ?>">Activités</a>
                    <span class="separator">/</span>
                    <span class="current">Réseaux de formation</span>
                </div>
                <h1 class="page-title">Réseaux de formation</h1>
                <p class="page-description">
                    Développement de réseaux collaboratifs pour la formation aux enjeux forestiers
                </p>
            </div>
        </div>

        <div class="page-content">
            <div class="container">
                <?php
                if (have_posts()) :
                    while (have_posts()) : the_post();
                        the_content();
                    endwhile;
                else :
                    ?>
                    <div class="content-section">
                        <h2>Réseaux de formation forestière</h2>
                        <p>
                            Le projet FORESTT-HUB développe des réseaux de formation pour renforcer les compétences 
                            et faciliter les échanges entre acteurs de la filière forestière.
                        </p>
                        
                        <div class="formation-networks">
                            <div class="network-card">
                                <h3>Réseau Formation Recherche</h3>
                                <p>
                                    Mise en réseau des formations de recherche (Masters, Doctorats) 
                                    spécialisées dans les sciences forestières.
                                </p>
                                <div class="network-features">
                                    <ul>
                                        <li>Cartographie des formations</li>
                                        <li>Échanges d'étudiants</li>
                                        <li>Modules communs</li>
                                        <li>Stages inter-établissements</li>
                                    </ul>
                                </div>
                            </div>
                            
                            <div class="network-card">
                                <h3>Réseau Formation Professionnelle</h3>
                                <p>
                                    Développement de formations continues pour les professionnels 
                                    de la filière forestière.
                                </p>
                                <div class="network-features">
                                    <ul>
                                        <li>Formations certifiantes</li>
                                        <li>Webinaires spécialisés</li>
                                        <li>Ateliers pratiques</li>
                                        <li>Échanges d'expériences</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                endif;
                ?>
            </div>
        </div>

    </main><!-- #main -->
</div><!-- #primary -->

<?php
get_footer();
?>